<?php
session_start();
require_once 'api/db.php';

$message = '';
$messageType = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $fullName = trim($_POST['full_name'] ?? '');
    $phone = trim($_POST['phone'] ?? '');
    $password = trim($_POST['password'] ?? '');
    $address = trim($_POST['address'] ?? '');
    $securityCode = trim($_POST['security_code'] ?? '');
    
    // کد امنیتی (تغییر دهید!)
    $correctCode = 'CREATE2024';
    
    if ($securityCode !== $correctCode) {
        $message = 'کد امنیتی نادرست است';
        $messageType = 'error';
    } elseif (!$fullName || !$phone || !$password) {
        $message = 'لطفا فیلدهای الزامی را پر کنید';
        $messageType = 'error';
    } elseif (strlen($password) < 6) {
        $message = 'رمز عبور باید حداقل 6 کاراکتر باشد';
        $messageType = 'error';
    } else {
        try {
            $stmt = $conn->prepare("SELECT id FROM users WHERE phone = ?");
            $stmt->execute([$phone]);
            
            if ($stmt->fetch()) {
                $message = 'این شماره موبایل قبلا ثبت شده است';
                $messageType = 'error';
            } else {
                $stmt = $conn->prepare("INSERT INTO users (full_name, phone, password, address, role, created_at) VALUES (?, ?, ?, ?, 'admin', ?)");
                $stmt->execute([$fullName, $phone, $password, $address, time() * 1000]);
                
                $message = 'ادمین با موفقیت ایجاد شد';
                $messageType = 'success';
            }
        } catch (PDOException $e) {
            $message = 'خطا در اتصال به دیتابیس';
            $messageType = 'error';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ایجاد ادمین</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;600;700&display=swap');
        * { font-family: 'Vazirmatn', sans-serif; }
        .gradient-bg { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
    </style>
</head>
<body class="bg-gray-50 min-h-screen flex items-center justify-center p-4">
    
    <div class="max-w-md w-full">
        <div class="bg-white rounded-2xl shadow-2xl overflow-hidden">
            <div class="gradient-bg text-white p-8 text-center">
                <div class="w-16 h-16 bg-white bg-opacity-20 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-user-shield text-3xl"></i>
                </div>
                <h1 class="text-2xl font-bold">ایجاد ادمین جدید</h1>
                <p class="text-purple-100 mt-2">افزودن مدیر به سیستم</p>
            </div>
            
            <div class="p-8">
                <?php if ($message): ?>
                <div class="mb-6 p-4 rounded-xl <?= $messageType === 'success' ? 'bg-green-50 border-r-4 border-green-500' : 'bg-red-50 border-r-4 border-red-500' ?>">
                    <div class="flex items-center gap-3">
                        <i class="fas <?= $messageType === 'success' ? 'fa-check-circle text-green-500' : 'fa-exclamation-circle text-red-500' ?> text-xl"></i>
                        <p class="<?= $messageType === 'success' ? 'text-green-700' : 'text-red-700' ?>"><?= htmlspecialchars($message) ?></p>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if ($messageType === 'success'): ?>
                <div class="text-center space-y-3">
                    <a href="login.php" class="block gradient-bg text-white px-6 py-3 rounded-xl font-bold hover:shadow-xl transition-all">
                        <i class="fas fa-sign-in-alt ml-2"></i>
                        ورود به سیستم
                    </a>
                    <button onclick="location.reload()" class="block w-full bg-gray-100 text-gray-700 px-6 py-3 rounded-xl font-bold hover:bg-gray-200 transition-all">
                        <i class="fas fa-plus ml-2"></i>
                        ایجاد ادمین دیگر
                    </button>
                </div>
                <?php else: ?>
                
                <div class="bg-amber-50 border-r-4 border-amber-500 p-4 rounded-lg mb-6">
                    <div class="flex items-start gap-3">
                        <i class="fas fa-exclamation-triangle text-amber-500 text-xl mt-1"></i>
                        <div class="text-sm text-amber-800">
                            <p class="font-semibold mb-1">هشدار امنیتی:</p>
                            <p>این صفحه فقط برای ایجاد مدیران سیستم است.</p>
                        </div>
                    </div>
                </div>
                
                <form method="POST" class="space-y-5">
                    <div>
                        <label class="block text-gray-700 font-semibold mb-2">
                            <i class="fas fa-shield-alt text-red-600 ml-2"></i>
                            کد امنیتی *
                        </label>
                        <input type="text" name="security_code" required
                               placeholder="کد امنیتی"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-purple-500 focus:outline-none transition-all">
                    </div>
                    
                    <div>
                        <label class="block text-gray-700 font-semibold mb-2">
                            <i class="fas fa-user text-blue-600 ml-2"></i>
                            نام و نام خانوادگی *
                        </label>
                        <input type="text" name="full_name" required
                               placeholder="نام کامل"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-purple-500 focus:outline-none transition-all">
                    </div>
                    
                    <div>
                        <label class="block text-gray-700 font-semibold mb-2">
                            <i class="fas fa-phone text-green-600 ml-2"></i>
                            شماره موبایل *
                        </label>
                        <input type="text" name="phone" required
                               placeholder="09123456789"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-purple-500 focus:outline-none transition-all">
                    </div>
                    
                    <div>
                        <label class="block text-gray-700 font-semibold mb-2">
                            <i class="fas fa-lock text-purple-600 ml-2"></i>
                            رمز عبور *
                        </label>
                        <input type="password" name="password" required
                               placeholder="حداقل 6 کاراکتر"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-purple-500 focus:outline-none transition-all">
                    </div>
                    
                    <div>
                        <label class="block text-gray-700 font-semibold mb-2">
                            <i class="fas fa-map-marker-alt text-orange-600 ml-2"></i>
                            آدرس
                        </label>
                        <textarea name="address" rows="3"
                                  placeholder="آدرس (اختیاری)"
                                  class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-purple-500 focus:outline-none transition-all"></textarea>
                    </div>
                    
                    <button type="submit" class="w-full gradient-bg text-white px-6 py-4 rounded-xl font-bold hover:shadow-2xl transition-all transform hover:scale-105">
                        <i class="fas fa-user-plus ml-2"></i>
                        ایجاد ادمین
                    </button>
                </form>
                
                <div class="mt-6 pt-6 border-t border-gray-200 text-center">
                    <a href="login.php" class="text-sm text-gray-600 hover:text-purple-600 transition">
                        <i class="fas fa-arrow-right ml-1"></i>
                        بازگشت به صفحه ورود
                    </a>
                </div>
                
                <?php endif; ?>
            </div>
        </div>
        
        <div class="mt-6 text-center text-xs text-gray-500">
            <p>
                <i class="fas fa-info-circle"></i>
                کد امنیتی را در فایل create_admin.php تغییر دهید
            </p>
        </div>
    </div>

</body>
</html>
