<?php
session_start();
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <!-- Meta Basic -->
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">

    <title>خشکشویی مدرن اکسپرس – سفارش آنلاین، تحویل ۲۴ ساعته</title>

    <!-- SEO Meta -->
    <meta name="description" content="خشکشویی آنلاین اکسپرسکلین؛ ثبت سفارش اینترنتی، جمع‌آوری و تحویل درب منزل، شستشوی تخصصی لباس، کفش، پرده و پتو با مواد نانو و دستگاه‌های صنعتی.">
    <meta name="keywords" content="خشکشویی آنلاین, خشکشویی درب منزل, شستشوی لباس, شستشوی کتانی, خشکشویی پرده, خشکشویی پتو, سفارش اینترنتی خشکشویی">
    <meta name="author" content="ExpressClean">

    <!-- Open Graph / Social -->
    <meta property="og:title" content="خشکشویی آنلاین اکسپرس – تحویل ۲۴ ساعته">
    <meta property="og:description" content="سفارش آنلاین خشکشویی، جمع‌آوری درب منزل، شستشو تخصصی و تحویل در کمتر از ۲۴ ساعت.">
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://example.com/">
    <meta property="og:image" content="https://images.unsplash.com/photo-1545173168-9f1947eebb8f?auto=format&fit=crop&w=1200&q=80">

    <!-- Favicon (نماد کوچک) -->
    <link rel="icon" type="image/png" href="/favicon.png">

    <!-- Tailwind CSS (CDN) -->
    <script src="https://cdn.tailwindcss.com?plugins=typography,forms,line-clamp,aspect-ratio"></script>

    <!-- Tailwind Config -->
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    fontFamily: {
                        vazir: ['Vazirmatn', 'system-ui', 'sans-serif'],
                    },
                    colors: {
                        primary: {
                            50: '#f5f3ff',
                            100: '#ede9fe',
                            400: '#a78bfa',
                            500: '#8b5cf6',
                            600: '#7c3aed',
                            700: '#6d28d9',
                            900: '#4c1d95',
                        },
                        accent: {
                            400: '#f472b6',
                            500: '#ec4899',
                            600: '#db2777',
                        },
                        dark: {
                            800: '#1f2937',
                            900: '#020617',
                        }
                    },
                    backgroundImage: {
                        'hero-texture': "radial-gradient(circle at top left, rgba(139,92,246,0.16), transparent 55%), radial-gradient(circle at bottom right, rgba(236,72,153,0.16), transparent 55%)",
                    },
                    boxShadow: {
                        'glass': '0 18px 45px rgba(15,23,42,0.18)',
                        'soft': '0 12px 30px rgba(15,23,42,0.12)',
                        'neon': '0 0 18px rgba(139,92,246,0.55)',
                    },
                    animation: {
                        'float-slow': 'float 12s ease-in-out infinite',
                        'fade-up': 'fadeUp 0.6s ease-out forwards',
                    },
                    keyframes: {
                        float: {
                            '0%': { transform: 'translate3d(0,0,0) scale(1)' },
                            '50%': { transform: 'translate3d(12px,-18px,0) scale(1.02)' },
                            '100%': { transform: 'translate3d(-4px,10px,0) scale(1)' },
                        },
                        fadeUp: {
                            '0%': { opacity: 0, transform: 'translateY(18px)' },
                            '100%': { opacity: 1, transform: 'translateY(0)' },
                        },
                    }
                }
            }
        }
    </script>

    <!-- FontAwesome -->
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css"
          integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA=="
          crossorigin="anonymous" referrerpolicy="no-referrer"/>

    <!-- Vazirmatn -->
    <link rel="stylesheet"
          href="https://cdn.jsdelivr.net/gh/rastikerdar/vazirmatn@v33.003/dist/font-face.css">

    <style>
        :root {
            color-scheme: light dark;
        }
        html {
            scroll-behavior: smooth;
        }
        body {
            background-color: #f3f4f6;
        }
        .glass {
            background: rgba(255,255,255,0.78);
            backdrop-filter: blur(16px);
            -webkit-backdrop-filter: blur(16px);
            border: 1px solid rgba(255,255,255,0.9);
        }
        .glass-dark {
            background: rgba(15,23,42,0.92);
            backdrop-filter: blur(16px);
            -webkit-backdrop-filter: blur(16px);
            border: 1px solid rgba(148,163,184,0.18);
        }
        .scrollbar-thin::-webkit-scrollbar {
            width: 4px;
        }
        .scrollbar-thin::-webkit-scrollbar-thumb {
            background-color: rgba(148,163,184,0.8);
            border-radius: 999px;
        }
        .scrollbar-thin::-webkit-scrollbar-track {
            background: transparent;
        }
    </style>

    <!-- JSON-LD Schema (Local Business) -->
    <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "LocalBusiness",
      "name": "اکسپرسکلین – خشکشویی آنلاین",
      "image": "https://images.unsplash.com/photo-1545173168-9f1947eebb8f?auto=format&fit=crop&w=800&q=80",
      "url": "https://example.com/",
      "telephone": "+98-21-00000000",
      "address": {
        "@type": "PostalAddress",
        "addressLocality": "تهران",
        "addressCountry": "IR"
      },
      "servesCuisine": "n/a",
      "priceRange": "IRR"
    }
    </script>
</head>

<body class="font-vazir text-gray-800 antialiased overflow-x-hidden bg-gray-50">

<!-- Root wrapper for dark mode toggle -->
<div id="app" class="min-h-screen relative">

    <!-- Background layer -->
    <div class="pointer-events-none fixed inset-0 bg-hero-texture opacity-80 -z-10"></div>

    <!-- ================= HEADER / NAVBAR ================= -->
    <header class="sticky top-0 z-40 backdrop-blur-xl bg-white/70 border-b border-slate-100">
        <nav class="max-w-7xl mx-auto px-3 sm:px-6 lg:px-8 py-3 flex items-center justify-between gap-4">
            <!-- Logo -->
            <a href="#top" class="flex items-center gap-2 group">
                <div class="w-10 h-10 rounded-2xl bg-gradient-to-tr from-primary-600 to-accent-500 text-white flex items-center justify-center shadow-neon">
                    <i class="fa-solid fa-shirt text-lg"></i>
                </div>
                <div class="hidden sm:flex flex-col">
                    <span class="font-black text-lg tracking-tight text-gray-900">
                        اکسپرس<span class="text-primary-600">کلین</span>
                    </span>
                    <span class="text-[11px] text-gray-400">خشکشویی آنلاین | تحویل ۲۴ ساعته</span>
                </div>
            </a>

            <!-- Desktop Menu -->
            <div class="hidden md:flex items-center gap-7 text-sm font-medium text-gray-600">
                <a href="#services" class="hover:text-primary-600 transition-colors">خدمات</a>
                <a href="#calculator" class="hover:text-primary-600 transition-colors">محاسبه هزینه</a>
                <a href="#process" class="hover:text-primary-600 transition-colors">مراحل کار</a>
                <a href="#faq" class="hover:text-primary-600 transition-colors">سوالات متداول</a>
            </div>

            <!-- Right: Auth & CTA -->
            <div class="flex items-center gap-3">
                <?php if (isset($_SESSION['user_id'])): ?>
                    <a href="pages/user/dashboard.php"
                       class="hidden sm:inline-flex items-center gap-2 text-xs sm:text-sm font-bold text-gray-700 hover:text-primary-600 transition">
                        <i class="fa-regular fa-circle-user text-lg"></i>
                        <span>پنل کاربری</span>
                    </a>
                <?php else: ?>
                    <a href="login.php"
                       class="hidden sm:inline-flex text-xs sm:text-sm font-bold text-gray-600 hover:text-primary-600 transition">
                        ورود
                    </a>
                    <a href="register.php"
                       class="hidden sm:inline-flex items-center text-xs sm:text-sm font-bold px-4 py-2 rounded-full bg-gray-900 text-white hover:bg-gray-800 transition shadow-soft">
                        شروع رایگان
                    </a>
                <?php endif; ?>

                <!-- Mobile Menu Button (optional – بدون منوی واقعی برای سادگی) -->
                <button type="button"
                        onclick="document.getElementById('mobile-nav').classList.toggle('hidden')"
                        class="inline-flex md:hidden items-center justify-center w-9 h-9 rounded-xl border border-gray-200 bg-white text-gray-700">
                    <i class="fa-solid fa-bars text-sm"></i>
                </button>
            </div>
        </nav>

        <!-- Simple Mobile Nav -->
        <div id="mobile-nav" class="md:hidden hidden border-t border-slate-100 bg-white/95 backdrop-blur-xl">
            <div class="max-w-7xl mx-auto px-4 py-3 flex flex-wrap gap-4 text-sm text-gray-700">
                <a href="#services" class="block w-full">خدمات</a>
                <a href="#calculator" class="block w-full">محاسبه هزینه</a>
                <a href="#process" class="block w-full">مراحل کار</a>
                <a href="#faq" class="block w-full">سوالات متداول</a>
                <div class="mt-2 flex gap-3">
                    <?php if (isset($_SESSION['user_id'])): ?>
                        <a href="pages/user/dashboard.php"
                           class="flex-1 inline-flex justify-center items-center px-3 py-2 rounded-xl bg-gray-900 text-white text-xs">
                            ورود به پنل
                        </a>
                    <?php else: ?>
                        <a href="login.php"
                           class="flex-1 inline-flex justify-center items-center px-3 py-2 rounded-xl border border-gray-200 text-xs">
                            ورود
                        </a>
                        <a href="register.php"
                           class="flex-1 inline-flex justify-center items-center px-3 py-2 rounded-xl bg-primary-600 text-white text-xs">
                            ثبت‌نام
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </header>

    <!-- ================= HERO ================= -->
    <section id="top" class="relative overflow-hidden">
        <!-- Color blobs -->
        <div class="pointer-events-none absolute -top-40 -right-32 w-80 h-80 bg-primary-400/40 blur-3xl rounded-full animate-float-slow -z-10"></div>
        <div class="pointer-events-none absolute -bottom-40 -left-32 w-80 h-80 bg-accent-400/40 blur-3xl rounded-full animate-float-slow -z-10"></div>

        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 pt-12 sm:pt-16 lg:pt-24 pb-16 lg:pb-24">
            <div class="grid lg:grid-cols-[1.1fr_minmax(0,1fr)] items-center gap-10 lg:gap-16">
                <!-- Text -->
                <div class="space-y-6 animate-fade-up">
                    <div class="inline-flex items-center gap-2 px-3 py-1.5 rounded-full border border-primary-100 bg-white/80 text-primary-700 text-[11px] sm:text-xs font-bold shadow-sm">
                        <span class="w-4 h-4 rounded-full bg-green-400/80"></span>
                        خشکشویی آنلاین درب منزل – فعال در اکثر مناطق تهران
                    </div>

                    <h1 class="text-3xl sm:text-4xl lg:text-5xl xl:text-6xl font-black leading-tight text-slate-900">
                        لباس‌های شما، <span class="text-transparent bg-clip-text bg-gradient-to-l from-primary-600 via-accent-500 to-primary-400">
                        مثل روز اول
                        </span>
                    </h1>

                    <p class="text-base sm:text-lg text-gray-600 max-w-xl leading-relaxed">
                        فقط در ۶۰ ثانیه سفارش دهید؛ پیک ما لباس‌ها را از درب منزل تحویل می‌گیرد و
                        حداکثر تا ۲۴ ساعت بعد، تمیز، اتوشده و کاور شده تحویل می‌دهد.
                    </p>

                    <!-- CTAs -->
                    <div class="flex flex-col sm:flex-row items-center gap-3 sm:gap-4 pt-2">
                        <button
                            type="button"
                            onclick="document.getElementById('calculator').scrollIntoView({behavior:'smooth'})"
                            class="w-full sm:w-auto inline-flex items-center justify-center px-6 sm:px-8 py-3.5 rounded-2xl bg-primary-600 hover:bg-primary-700 text-white text-sm sm:text-base font-bold shadow-neon transition-transform hover:-translate-y-0.5">
                            <i class="fa-solid fa-bolt ml-2 text-sm"></i>
                            محاسبه سریع قیمت و ثبت سفارش
                        </button>
                        <a href="#process"
                           class="w-full sm:w-auto inline-flex items-center justify-center px-6 sm:px-7 py-3.5 rounded-2xl bg-white text-gray-800 border border-gray-200 text-sm sm:text-base font-bold hover:bg-gray-50 shadow-soft transition">
                            <i class="fa-regular fa-circle-play ml-2"></i>
                            نحوه کار اکسپرسکلین
                        </a>
                    </div>

                    <!-- Trust badges -->
                    <div class="flex flex-wrap items-center gap-5 text-[11px] sm:text-xs text-gray-500 pt-4">
                        <div class="inline-flex items-center gap-2">
                            <i class="fa-solid fa-shield-halved text-green-500 text-sm"></i>
                            <span>بیمه کامل البسه تا ۵ میلیون تومان</span>
                        </div>
                        <div class="inline-flex items-center gap-2">
                            <i class="fa-solid fa-biohazard text-amber-500 text-sm"></i>
                            <span>ضدعفونی UV و مواد نانو ضدحساسیت</span>
                        </div>
                        <div class="inline-flex items-center gap-2">
                            <i class="fa-solid fa-clock text-primary-500 text-sm"></i>
                            <span>تحویل عادی ۲۴ ساعته | فوری زیر ۱۲ ساعت</span>
                        </div>
                    </div>
                </div>

                <!-- Visual Card -->
                <div class="relative">
                    <div class="relative glass rounded-[2.2rem] p-3 sm:p-4 shadow-glass border border-white/90">
                        <div class="relative rounded-[1.9rem] overflow-hidden">
                            <img
                                src="https://images.unsplash.com/photo-1581578731548-c64695cc6952?auto=format&fit=crop&w=900&q=80"
                                alt="خشکشویی مدرن"
                                class="w-full h-[260px] sm:h-[340px] lg:h-[380px] object-cover">
                            
                            <!-- Eco Badge -->
                            <div class="absolute bottom-4 left-4">
                                <div class="glass px-4 py-3 rounded-2xl flex items-center gap-3 shadow-soft">
                                    <div class="w-9 h-9 rounded-xl bg-green-100 text-green-600 flex items-center justify-center">
                                        <i class="fa-solid fa-leaf"></i>
                                    </div>
                                    <div class="text-xs">
                                        <p class="text-gray-500">دوستدار محیط زیست</p>
                                        <p class="font-bold text-gray-800 text-sm">شستشوی اکو با مصرف آب کم</p>
                                    </div>
                                </div>
                            </div>

                            <!-- Rating -->
                            <div class="absolute top-4 right-4">
                                <div class="glass px-3 py-2 rounded-xl flex items-center gap-2 text-xs shadow-soft">
                                    <span class="flex text-amber-400 text-[11px]">
                                        <i class="fa-solid fa-star ml-0.5"></i>
                                        <i class="fa-solid fa-star ml-0.5"></i>
                                        <i class="fa-solid fa-star ml-0.5"></i>
                                        <i class="fa-solid fa-star ml-0.5"></i>
                                        <i class="fa-regular fa-star ml-0.5"></i>
                                    </span>
                                    <span class="font-bold text-gray-800">۴٫۷</span>
                                    <span class="text-[10px] text-gray-400">(بیش از ۳۲۰۰ سفارش)</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Small chips under image -->
                    <div class="mt-4 flex flex-wrap gap-2 text-[11px] text-gray-500">
                        <span class="inline-flex items-center gap-1 px-3 py-1 rounded-full bg-white shadow-soft border border-gray-100">
                            <i class="fa-solid fa-credit-card text-xs text-primary-500"></i>
                            پرداخت در محل / آنلاین
                        </span>
                        <span class="inline-flex items-center gap-1 px-3 py-1 rounded-full bg-white shadow-soft border border-gray-100">
                            <i class="fa-solid fa-truck-fast text-xs text-emerald-500"></i>
                            پیک رفت و برگشت برای سفارشات بالای ۳۰۰ هزار تومان رایگان
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- ================= SERVICES ================= -->
    <section id="services" class="py-16 sm:py-20 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex flex-col md:flex-row md:items-end md:justify-between gap-6 mb-12">
                <div>
                    <h2 class="text-2xl sm:text-3xl font-black text-gray-900 mb-2">
                        خدمات تخصصی خشکشویی اکسپرسکلین
                    </h2>
                    <p class="text-sm sm:text-base text-gray-500 max-w-xl">
                        از لباس‌های روزمره تا کت‌وشلوار رسمی، پرده، پتو و حتی کتانی‌های ظریف؛
                        برای هر جنس و بافتی یک پروتکل شستشوی تخصصی داریم.
                    </p>
                </div>
                <div class="flex flex-wrap gap-2 text-[11px] text-gray-500">
                    <span class="inline-flex items-center gap-1 px-3 py-1 rounded-full bg-gray-50 border border-gray-100">
                        <i class="fa-solid fa-shield-heart text-red-400 text-xs"></i>
                        ضمانت بازگشت وجه در صورت نارضایتی
                    </span>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-6 lg:gap-8">
                <!-- Card 1 -->
                <article class="group relative overflow-hidden rounded-3xl bg-gradient-to-br from-slate-50 to-white border border-slate-100 p-6 sm:p-7 transition hover:-translate-y-1 hover:shadow-glass">
                    <div class="absolute -top-8 -left-8 w-24 h-24 rounded-full bg-primary-100 opacity-40 group-hover:opacity-60 transition"></div>
                    <div class="relative z-10">
                        <div class="w-14 h-14 rounded-2xl bg-white flex items-center justify-center text-primary-600 shadow-soft mb-4 text-2xl">
                            <i class="fa-solid fa-shirt"></i>
                        </div>
                        <h3 class="text-lg font-bold text-slate-900 mb-2">خشکشویی، اتو و لکه‌بری لباس</h3>
                        <p class="text-sm text-gray-600 leading-relaxed mb-4">
                            شستشوی استاندارد انواع پیراهن، شلوار، مانتو، کت و شومیز با
                            مواد شوینده آلمانی و بخار فشارقوی برای عمر بیشتر لباس.
                        </p>
                        <ul class="text-[11px] text-gray-500 space-y-1">
                            <li>• تفکیک رنگ و جنس به‌صورت خودکار</li>
                            <li>• کاور اختصاصی هر مشتری</li>
                            <li>• اتوی بخار صنعتی ضد برق‌افتادگی</li>
                        </ul>
                    </div>
                </article>

                <!-- Card 2 -->
                <article class="group relative overflow-hidden rounded-3xl bg-gradient-to-br from-pink-50 to-white border border-pink-100 p-6 sm:p-7 transition hover:-translate-y-1 hover:shadow-glass">
                    <div class="absolute -top-10 -left-6 w-28 h-28 rounded-full bg-accent-400/40 blur-xl opacity-50 group-hover:opacity-75 transition"></div>
                    <div class="relative z-10">
                        <div class="w-14 h-14 rounded-2xl bg-white flex items-center justify-center text-accent-500 shadow-soft mb-4 text-2xl">
                            <i class="fa-solid fa-shoe-prints"></i>
                        </div>
                        <h3 class="text-lg font-bold text-slate-900 mb-2">شستشوی تخصصی کفش و کتانی</h3>
                        <p class="text-sm text-gray-600 leading-relaxed mb-4">
                            پاکسازی عمیق کفی، رویه و بندها با دستگاه مخصوص کتانی،
                            بدون باز شدن دوخت و بدون تغییر فرم.
                        </p>
                        <ul class="text-[11px] text-gray-500 space-y-1">
                            <li>• مناسب کتانی سفید، ورزشی و رانینگ</li>
                            <li>• شستشوی کم‌آب برای چرم و جیر</li>
                            <li>• ضدعفونی و ازبین‌بردن بوی ناخوشایند</li>
                        </ul>
                    </div>
                </article>

                <!-- Card 3 -->
                <article class="group relative overflow-hidden rounded-3xl bg-gradient-to-br from-slate-900 to-slate-800 text-white p-6 sm:p-7 transition hover:-translate-y-1 hover:shadow-glass">
                    <div class="absolute -top-12 -right-10 w-36 h-36 rounded-full bg-white/5 blur-xl"></div>
                    <div class="relative z-10">
                        <div class="w-14 h-14 rounded-2xl bg-white/10 flex items-center justify-center text-2xl shadow-soft">
                            <i class="fa-solid fa-layer-group"></i>
                        </div>
                        <h3 class="text-lg font-bold mt-4 mb-2">پرده، پتو و کالای خواب حجیم</h3>
                        <p class="text-sm text-slate-100/90 leading-relaxed mb-4">
                            باز و نصب رایگان پرده در برخی مناطق، شستشوی عمیق پتو، لحاف،
                            روفرشی و ملحفه با دستگاه‌های درام بزرگ و خشک‌کن صنعتی.
                        </p>
                        <ul class="text-[11px] text-slate-300/90 space-y-1">
                            <li>• ضدحساسیت و مناسب کودک</li>
                            <li>• ضدعفونی و ازبین‌بردن مایت و گردوغبار</li>
                            <li>• بسته‌بندی وکیوم برای نگهداری طولانی</li>
                        </ul>
                    </div>
                </article>
            </div>
        </div>
    </section>

    <!-- ================= CALCULATOR ================= -->
    <section id="calculator" class="relative py-18 sm:py-20 bg-slate-950 text-white overflow-hidden">
        <div class="absolute inset-0 opacity-40"
             style="background: radial-gradient(circle at top, rgba(129,140,248,0.35), transparent 55%), radial-gradient(circle at bottom, rgba(236,72,153,0.35), transparent 55%);">
        </div>

        <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
            <div class="grid lg:grid-cols-2 gap-10 lg:gap-14 items-center">
                <!-- Left Info -->
                <div>
                    <p class="text-xs uppercase tracking-[0.35em] text-primary-300 mb-3">
                        PRICING • TRANSPARENCY
                    </p>
                    <h2 class="text-2xl sm:text-3xl lg:text-4xl font-black mb-3">
                        قبل از سفارش، هزینه را شفاف ببینید
                    </h2>
                    <p class="text-sm sm:text-base text-slate-200 leading-relaxed mb-6">
                        لیست اقلام مورد نیازتان را انتخاب کنید تا برآورد تقریبی هزینه را در لحظه ببینید.
                        مبلغ نهایی پس از تحویل و بررسی کارشناسی در پنل کاربری تایید می‌شود.
                    </p>

                    <ul class="space-y-3 text-sm text-slate-200/85">
                        <li class="flex items-start gap-3">
                            <span class="mt-0.5 w-7 h-7 rounded-full bg-primary-500/20 border border-primary-400/50 flex items-center justify-center text-xs">
                                ۱
                            </span>
                            <span>قیمت‌ها بر اساس نرخ مصوب اتحادیه خشک‌شویی تهران محاسبه شده‌اند.</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <span class="mt-0.5 w-7 h-7 rounded-full bg-primary-500/20 border border-primary-400/50 flex items-center justify-center text-xs">
                                ۲
                            </span>
                            <span>برای سفارشات بالای <b>۳۰۰٫۰۰۰ تومان</b>، هزینه پیک رفت و برگشت کاملاً رایگان است.</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <span class="mt-0.5 w-7 h-7 rounded-full bg-primary-500/20 border border-primary-400/50 flex items-center justify-center text-xs">
                                ۳
                            </span>
                            <span>امکان پرداخت در محل، اعتباری و کیف‌پول داخل پنل وجود دارد.</span>
                        </li>
                    </ul>
                </div>

                <!-- Calculator Card -->
                <div class="glass-dark rounded-3xl p-5 sm:p-6 lg:p-7 shadow-glass">
                    <div class="flex items-center justify-between border-b border-slate-700/60 pb-3 mb-4">
                        <div>
                            <h3 class="text-lg sm:text-xl font-bold">ماشین‌حساب برآورد هزینه</h3>
                            <p class="text-[11px] text-slate-400 mt-1">اقلام مورد نیازتان را انتخاب کنید.</p>
                        </div>
                        <span class="text-[10px] px-2.5 py-1 rounded-full bg-slate-800 text-slate-300 border border-slate-600">
                            نرخ اتحادیه ۱۴۰۲
                        </span>
                    </div>

                    <!-- List -->
                    <div id="calculator-items"
                         class="space-y-3 max-h-[330px] overflow-y-auto pr-1 scrollbar-thin">
                        <!-- Skeleton -->
                        <div class="animate-pulse space-y-2.5" id="calculator-skeleton">
                            <div class="h-14 bg-slate-800/60 rounded-2xl"></div>
                            <div class="h-14 bg-slate-800/60 rounded-2xl"></div>
                            <div class="h-14 bg-slate-800/60 rounded-2xl"></div>
                        </div>
                    </div>

                    <!-- Total -->
                    <div class="mt-5 pt-4 border-t border-slate-700/60 space-y-3">
                        <div class="flex justify-between items-end">
                            <div class="text-xs text-slate-400">
                                <p>مجموع برآورد فعلی:</p>
                                <p class="mt-1">هزینه نهایی بعد از بررسی در خشکشویی، در فاکتور تایید می‌شود.</p>
                            </div>
                            <div class="text-right">
                                <div id="total-price" class="text-2xl font-black text-primary-300">
                                    ۰ تومان
                                </div>
                            </div>
                        </div>

                        <a href="<?php echo isset($_SESSION['user_id']) ? 'pages/user/dashboard.php' : 'register.php'; ?>"
                           class="block w-full py-3.5 rounded-2xl bg-white text-slate-900 text-center text-sm sm:text-base font-bold hover:bg-slate-100 transition shadow-soft hover:shadow-neon">
                            تایید و ادامه ثبت سفارش
                            <i class="fa-solid fa-arrow-left mr-2 text-xs"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- ================= PROCESS ================= -->
    <section id="process" class="py-16 sm:py-20 bg-gray-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex flex-col md:flex-row md:items-end md:justify-between gap-6 mb-10">
                <div>
                    <h2 class="text-2xl sm:text-3xl font-black text-gray-900 mb-2">فرآیند ساده؛ فقط در ۴ مرحله</h2>
                    <p class="text-sm sm:text-base text-gray-500 max-w-xl">
                        از لحظه ثبت سفارش تا تحویل نهایی، همه چیز شفاف و قابل پیگیری است.
                    </p>
                </div>
                <div class="text-xs text-gray-500">
                    <i class="fa-solid fa-mobile-screen-button ml-1"></i>
                    امکان پیگیری لحظه‌ای سفارش در پنل کاربری
                </div>
            </div>

            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-5">
                <?php
                $steps = [
                    [
                        'icon' => 'fa-mobile-screen-button',
                        'title' => 'ثبت سفارش آنلاین',
                        'desc'  => 'انتخاب اقلام، آدرس و زمان مورد نظر شما در کمتر از ۱ دقیقه.',
                    ],
                    [
                        'icon' => 'fa-truck-pickup',
                        'title' => 'جمع‌آوری از درب منزل',
                        'desc'  => 'پیک اکسپرسکلین در بازه زمانی انتخاب‌شده، لباس‌ها را تحویل می‌گیرد.',
                    ],
                    [
                        'icon' => 'fa-soap',
                        'title' => 'شستشو و اتو تخصصی',
                        'desc'  => 'شستشو، ضدعفونی، لکه‌بری و اتو با دستگاه‌های صنعتی و مواد نانو.',
                    ],
                    [
                        'icon' => 'fa-shirt',
                        'title' => 'تحویل مثل روز اول',
                        'desc'  => 'لباس‌ها در کاور اختصاصی، مرتب و معطر تحویل شما می‌شوند.',
                    ],
                ];
                $i = 1;
                foreach ($steps as $step):
                ?>
                    <div class="bg-white p-5 rounded-3xl shadow-soft hover:shadow-glass transition relative">
                        <span class="absolute -top-4 -right-4 w-9 h-9 rounded-2xl bg-primary-600 text-white text-xs flex items-center justify-center font-bold shadow-neon">
                            <?php echo $i++; ?>
                        </span>
                        <div class="flex flex-col items-center text-center mt-2">
                            <i class="fa-solid <?php echo $step['icon']; ?> text-3xl text-gray-300 mb-3"></i>
                            <h4 class="font-bold text-gray-900 text-sm sm:text-base mb-1.5">
                                <?php echo $step['title']; ?>
                            </h4>
                            <p class="text-xs text-gray-500 leading-relaxed">
                                <?php echo $step['desc']; ?>
                            </p>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>

    <!-- ================= FAQ ================= -->
    <section id="faq" class="py-16 sm:py-20 bg-white">
        <div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-10">
                <h2 class="text-2xl sm:text-3xl font-black text-gray-900 mb-2">سوالات متداول</h2>
                <p class="text-sm sm:text-base text-gray-500">
                    اگر جواب سوالتان را پیدا نکردید، از چت آنلاین داخل سایت بپرسید.
                </p>
            </div>

            <div class="space-y-3">
                <!-- Q1 -->
                <details class="group bg-gray-50 rounded-2xl p-4 sm:p-5 transition">
                    <summary class="flex items-center justify-between cursor-pointer">
                        <div class="flex items-center gap-2 text-sm sm:text-base font-bold text-gray-800">
                            <i class="fa-regular fa-circle-question text-primary-500 text-sm"></i>
                            چقدر طول می‌کشد تا لباس‌ها آماده شوند؟
                        </div>
                        <span class="transition-transform group-open:rotate-180 text-gray-400">
                            <i class="fa-solid fa-chevron-down text-xs"></i>
                        </span>
                    </summary>
                    <div class="mt-3 text-xs sm:text-sm text-gray-600 leading-relaxed">
                        برای سرویس معمولی، حداکثر <b>۲۴ ساعت کاری</b> طول می‌کشد.
                        اگر سرویس اکسپرس را انتخاب کنید، بسته به حجم سفارش، بین <b>۶ تا ۱۲ ساعت</b> آماده و ارسال می‌شود.
                    </div>
                </details>

                <!-- Q2 -->
                <details class="group bg-gray-50 rounded-2xl p-4 sm:p-5 transition">
                    <summary class="flex items-center justify-between cursor-pointer">
                        <div class="flex items-center gap-2 text-sm sm:text-base font-bold text-gray-800">
                            <i class="fa-regular fa-circle-question text-primary-500 text-sm"></i>
                            آیا لکه‌های سخت هم کاملاً پاک می‌شوند؟
                        </div>
                        <span class="transition-transform group-open:rotate-180 text-gray-400">
                            <i class="fa-solid fa-chevron-down text-xs"></i>
                        </span>
                    </summary>
                    <div class="mt-3 text-xs sm:text-sm text-gray-600 leading-relaxed">
                        تیم لکه‌بری ما قبل از شستشو نوع لکه و جنس پارچه را بررسی می‌کند.
                        برای اکثر لکه‌ها (چربی، سس، عرق، گردوغبار و …) درصد موفقیت بسیار بالاست،
                        اما برای لکه‌های قدیمی، سوختگی یا تغییر رنگ شدید، ممکن است پاکسازی کامل ممکن نباشد.
                        در این موارد قبل از اقدام، از طریق تماس یا پیام داخل پنل با شما هماهنگ می‌کنیم.
                    </div>
                </details>

                <!-- Q3 -->
                <details class="group bg-gray-50 rounded-2xl p-4 sm:p-5 transition">
                    <summary class="flex items-center justify-between cursor-pointer">
                        <div class="flex items-center gap-2 text-sm sm:text-base font-bold text-gray-800">
                            <i class="fa-regular fa-circle-question text-primary-500 text-sm"></i>
                            آیا امکان پرداخت در محل وجود دارد؟
                        </div>
                        <span class="transition-transform group-open:rotate-180 text-gray-400">
                            <i class="fa-solid fa-chevron-down text-xs"></i>
                        </span>
                    </summary>
                    <div class="mt-3 text-xs sm:text-sm text-gray-600 leading-relaxed">
                        بله. شما می‌توانید هم به صورت <b>آنلاین</b> و هم از طریق
                        <b>پرداخت کارت‌خوان در محل</b> مبلغ را تسویه کنید.
                        همچنین امکان شارژ کیف‌پول در پنل کاربری و پرداخت اعتباری هم وجود دارد.
                    </div>
                </details>
            </div>
        </div>
    </section>

    <!-- ================= FOOTER ================= -->
    <footer class="bg-slate-950 text-slate-200 pt-12 sm:pt-16 pb-6 border-t border-slate-800">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex flex-col md:flex-row items-start md:items-center justify-between gap-8 mb-10">
                <!-- Brand -->
                <div class="flex items-center gap-3">
                    <div class="w-11 h-11 rounded-2xl bg-gradient-to-tr from-primary-600 to-accent-500 flex items-center justify-center text-lg">
                        <i class="fa-solid fa-shirt"></i>
                    </div>
                    <div>
                        <div class="text-xl font-black tracking-tight">
                            اکسپرس<span class="text-primary-300">کلین</span>
                        </div>
                        <p class="text-xs text-slate-400 mt-0.5">
                            خشکشویی آنلاین | نسل جدید خدمات شستشو درب منزل
                        </p>
                    </div>
                </div>

                <!-- Contact & Social -->
                <div class="flex flex-col md:items-end gap-3 text-xs text-slate-400">
                    <div class="flex flex-wrap gap-3 md:justify-end">
                        <a href="tel:02100000000" class="inline-flex items-center gap-1 hover:text-primary-300">
                            <i class="fa-solid fa-phone text-[11px]"></i>
                            ۰۲۱-۰۰۰۰۰۰۰۰ (۷ روز هفته)
                        </a>
                        <span class="inline-flex items-center gap-1">
                            <i class="fa-solid fa-location-dot text-[11px]"></i>
                            تهران – ارسال پیک در اکثر مناطق
                        </span>
                    </div>
                    <div class="flex gap-3">
                        <a href="#" class="w-9 h-9 rounded-full bg-white/5 flex items-center justify-center hover:bg-primary-600 text-slate-100 transition">
                            <i class="fa-brands fa-instagram text-sm"></i>
                        </a>
                        <a href="#" class="w-9 h-9 rounded-full bg-white/5 flex items-center justify-center hover:bg-primary-600 text-slate-100 transition">
                            <i class="fa-brands fa-telegram text-sm"></i>
                        </a>
                        <a href="#" class="w-9 h-9 rounded-full bg-white/5 flex items-center justify-center hover:bg-primary-600 text-slate-100 transition">
                            <i class="fa-brands fa-whatsapp text-sm"></i>
                        </a>
                    </div>
                </div>
            </div>

            <div class="border-t border-slate-800 pt-5 text-center text-xs text-slate-500">
                <p>
                    © ۲۰۲۶ اکسپرسکلین. تمامی حقوق این وب‌سایت محفوظ است.
                    | طراحی و توسعه با ❤️ برای تمیزی و راحتی شما.
                </p>
            </div>
        </div>
    </footer>
</div>

<!-- ============== SCRIPTS ============== -->

<script>
    // نمونه سرویس‌ها – در پروژه واقعی از API سمت سرور بخوانید
    const mockServices = [
        { id: 1, name: 'پیراهن مردانه', price: 45000, icon: 'fa-shirt' },
        { id: 2, name: 'شلوار پارچه‌ای', price: 40000, icon: 'fa-layer-group' },
        { id: 3, name: 'کت و شلوار', price: 120000, icon: 'fa-user-tie' },
        { id: 4, name: 'مانتو ساده', price: 60000, icon: 'fa-vest' },
        { id: 5, name: 'پتو یک نفره', price: 150000, icon: 'fa-bed' },
        { id: 6, name: 'کتانی ورزشی', price: 70000, icon: 'fa-shoe-prints' },
    ];

    document.addEventListener('DOMContentLoaded', () => {
        const container = document.getElementById('calculator-items');
        const skeleton = document.getElementById('calculator-skeleton');
        if (!container) return;

        // شبیه‌سازی تاخیر (مثل واکشی از سرور)
        setTimeout(() => {
            if (skeleton) skeleton.remove();
            renderServices(mockServices, container);
        }, 300);
    });

    function renderServices(services, container) {
        container.innerHTML = '';
        services.forEach(service => {
            const el = document.createElement('div');
            el.className = 'flex items-center justify-between p-3.5 rounded-2xl bg-slate-900/70 hover:bg-slate-900 transition border border-slate-700/60';
            el.innerHTML = `
                <div class="flex items-center gap-3">
                    <div class="w-9 h-9 rounded-xl bg-slate-800 text-primary-300 flex items-center justify-center shadow-soft text-base">
                        <i class="fa-solid ${service.icon}"></i>
                    </div>
                    <div class="space-y-0.5">
                        <h5 class="font-bold text-xs sm:text-sm text-slate-50">${service.name}</h5>
                        <span class="text-[11px] text-slate-400">${service.price.toLocaleString('fa-IR')} تومان</span>
                    </div>
                </div>
                <div class="flex items-center bg-slate-900 rounded-xl shadow-soft border border-slate-700 h-9">
                    <button type="button"
                            onclick="changeQty('${service.id}', 1)"
                            class="w-8 h-full flex items-center justify-center text-emerald-400 hover:bg-emerald-500/10 rounded-r-xl text-sm">
                        +
                    </button>
                    <span id="qty-${service.id}"
                          data-price="${service.price}"
                          class="w-9 text-center font-bold text-xs sm:text-sm text-slate-50">
                        0
                    </span>
                    <button type="button"
                            onclick="changeQty('${service.id}', -1)"
                            class="w-8 h-full flex items-center justify-center text-rose-400 hover:bg-rose-500/10 rounded-l-xl text-sm">
                        -
                    </button>
                </div>
            `;
            container.appendChild(el);
        });
    }

    function changeQty(id, delta) {
        const qtyEl = document.getElementById(`qty-${id}`);
        if (!qtyEl) return;
        let qty = parseInt(qtyEl.innerText) || 0;
        qty += delta;
        if (qty < 0) qty = 0;
        qtyEl.innerText = qty.toString();
        calculateTotal();
    }

    function calculateTotal() {
        let total = 0;
        document.querySelectorAll('[id^="qty-"]').forEach(el => {
            const qty = parseInt(el.innerText) || 0;
            const price = parseInt(el.dataset.price) || 0;
            total += qty * price;
        });
        const totalEl = document.getElementById('total-price');
        if (totalEl) {
            totalEl.innerText = total.toLocaleString('fa-IR') + ' تومان';
        }
    }
</script>

</body>
</html>
