<?php
header('Content-Type: text/html; charset=utf-8');
session_start();
require_once '../../api/db.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: ../../login.php");
    exit();
}

// Delete all corrupted settings
try {
    $conn->exec("DELETE FROM settings");
    echo "✓ تنظیمات قدیمی حذف شد<br>";
    
    // Insert fresh Persian data
    $defaults = [
        ['business_name', 'پاکشو'],
        ['business_phone', ''],
        ['business_address', ''],
        ['working_hours', 'شنبه تا پنجشنبه: 9 صبح تا 9 شب'],
        ['invoice_message', 'از اعتماد شما سپاسگزاریم'],
        ['tax_rate', '0'],
        ['default_discount', '0'],
        ['min_order_amount', '0'],
        ['delivery_fee', '0']
    ];
    
    $stmt = $conn->prepare("INSERT INTO settings (setting_key, setting_value) VALUES (?, ?)");
    foreach ($defaults as $row) {
        $stmt->execute($row);
    }
    
    echo "✓ تنظیمات جدید با UTF-8 صحیح ذخیره شد<br><br>";
    echo "<a href='settings.php' style='color: blue;'>بازگشت به تنظیمات</a>";
    
} catch (Exception $e) {
    echo "خطا: " . $e->getMessage();
}
?>
