<?php
session_start();
header("Cache-Control: no-cache, no-store, must-revalidate");
require_once '../../api/db.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: ../../login.php");
    exit();
}

$stmt = $conn->query("SELECT * FROM services ORDER BY id DESC");
$services = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl" class="scroll-smooth">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>مدیریت خدمات | پنل مدیریت</title>

    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="../../css/style.css">

    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        vazir: ['Vazirmatn', 'system-ui', 'sans-serif']
                    },
                    colors: {
                        primary: {
                            50: '#eef2ff',
                            100: '#e0e7ff',
                            300: '#a5b4fc',
                            500: '#6366f1',
                            600: '#4f46e5',
                        },
                        mint: {
                            100: '#e0fdf8',
                            500: '#14b8a6',
                        }
                    },
                    boxShadow: {
                        glass: '0 22px 55px rgba(15,23,42,0.18)',
                        card: '0 18px 45px rgba(148,163,184,0.30)',
                    },
                    borderRadius: {
                        '2xl': '1.25rem',
                        '3xl': '1.75rem',
                    }
                }
            }
        }
    </script>

    <style>
        body { font-family: 'Vazirmatn', 'system-ui', sans-serif; }
        [x-cloak] { display: none !important; }
        ::-webkit-scrollbar { width: 6px; height: 6px; }
        ::-webkit-scrollbar-track { background: transparent; }
        ::-webkit-scrollbar-thumb { background: #cbd5e1; border-radius: 999px; }
    </style>
</head>
<body class="bg-gradient-to-br from-sky-50 via-slate-50 to-primary-50 font-vazir text-slate-800">

<div class="flex min-h-screen overflow-hidden">

    <!-- Sidebar -->
    <aside class="hidden md:flex w-64 bg-slate-950 text-white flex-col shadow-2xl relative overflow-hidden">
        <div class="absolute inset-0 opacity-50 pointer-events-none">
            <div class="absolute -top-16 -left-16 w-40 h-40 bg-primary-500/40 rounded-full blur-3xl"></div>
            <div class="absolute -bottom-16 right-[-30px] w-44 h-44 bg-mint-500/40 rounded-full blur-3xl"></div>
        </div>

        <div class="relative h-16 flex items-center justify-center border-b border-slate-800">
            <div class="flex items-center gap-2">
                <div class="w-9 h-9 rounded-2xl bg-gradient-to-tr from-primary-500 to-mint-500 flex items-center justify-center text-white shadow-card">
                    <i class="fa-solid fa-sparkles text-lg"></i>
                </div>
                <div class="flex flex-col">
                    <span class="text-xs text-slate-300">پنل مدیریت</span>
                    <span class="text-sm font-bold tracking-tight">پاکشور</span>
                </div>
            </div>
        </div>

        <nav class="relative flex-1 p-4 space-y-2 z-10">
            <a href="admin.php"
               class="flex items-center px-4 py-2.5 text-sm rounded-2xl text-slate-300 hover:bg-white/5 hover:text-white transition-colors">
                <i class="fa-solid fa-list-check ml-3 w-5"></i>
                لیست سفارشات
            </a>
            <a href="order_create.php"
               class="flex items-center px-4 py-2.5 text-sm rounded-2xl text-slate-300 hover:bg-white/5 hover:text-white transition-colors">
                <i class="fa-solid fa-cart-plus ml-3 w-5"></i>
                ثبت سفارش جدید
            </a>
            <a href="services.php"
               class="flex items-center px-4 py-2.5 text-sm rounded-2xl bg-gradient-to-r from-primary-500 to-mint-500 text-white shadow-card">
                <i class="fa-solid fa-layer-group ml-3 w-5"></i>
                مدیریت خدمات
            </a>
        </nav>

        <div class="relative p-4 border-t border-slate-800 z-10">
            <a href="../../logout.php"
               class="flex items-center justify-center px-4 py-2.5 rounded-2xl bg-rose-500/10 text-rose-300 border border-rose-500/30 hover:bg-rose-500 hover:text-white transition-all text-sm font-medium">
                <i class="fa-solid fa-arrow-right-from-bracket ml-2"></i>
                خروج از حساب
            </a>
        </div>
    </aside>

    <!-- Main -->
    <main class="flex-1 flex flex-col overflow-hidden">

        <!-- Topbar -->
        <header class="bg-white/80 backdrop-blur border-b border-white/70 px-4 sm:px-6 py-3 shadow-sm flex items-center justify-between">
            <div class="flex items-center gap-3">
                <button class="md:hidden w-9 h-9 rounded-2xl bg-slate-100 text-slate-600 flex items-center justify-center">
                    <i class="fa-solid fa-bars text-sm"></i>
                </button>
                <div>
                    <div class="inline-flex items-center gap-1.5 px-2.5 py-1 rounded-full bg-primary-50 text-primary-600 text-[11px] border border-primary-100 mb-1">
                        <i class="fa-solid fa-layer-group text-[10px]"></i>
                        <span>مدیریت خدمات</span>
                    </div>
                    <h1 class="text-lg sm:text-xl font-extrabold text-slate-900 flex items-center gap-2">
                        <i class="fa-solid fa-swatchbook text-primary-500"></i>
                        لیست و تنظیمات خدمات
                    </h1>
                </div>
            </div>

            <div class="flex items-center gap-2">
                <button onclick="openAddModal()"
                        class="inline-flex items-center gap-1.5 bg-gradient-to-r from-primary-500 to-mint-500 text-white px-3 sm:px-4 py-2 rounded-2xl text-xs sm:text-sm font-bold shadow-card hover:shadow-[0_16px_40px_rgba(129,140,248,0.5)] transition-all">
                    <i class="fa-solid fa-plus text-[11px]"></i>
                    افزودن خدمت جدید
                </button>
            </div>
        </header>

        <!-- Content -->
        <div class="flex-1 overflow-auto p-4 sm:p-6 space-y-4">

            <!-- Info / filter bar -->
            <section class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-3">
                <div class="flex items-center gap-2 text-[11px] text-slate-500">
                    <div class="px-2.5 py-1 rounded-full bg-slate-900 text-slate-50 flex items-center gap-1.5">
                        <span class="w-1.5 h-1.5 rounded-full bg-emerald-400 animate-pulse"></span>
                        <span>تعداد خدمات ثبت‌شده:</span>
                        <span class="font-bold text-emerald-300">
                            <?php echo count($services); ?>
                        </span>
                    </div>
                    <span class="hidden sm:inline">
                        برای ویرایش هر خدمت، روی «ویرایش» کلیک کنید یا برای حذف، آیکون سطل زباله را بزنید.
                    </span>
                </div>

                <div class="flex items-center gap-2 text-[11px] text-slate-500">
                    <span class="hidden sm:inline-flex items-center gap-1.5 px-2.5 py-1 rounded-full bg-slate-50 border border-slate-200">
                        <i class="fa-solid fa-circle-info text-[10px] text-primary-500"></i>
                        آیکون می‌تواند FontAwesome یا تصویر PNG/SVG باشد.
                    </span>
                </div>
            </section>

            <!-- Services grid -->
            <section>
                <?php if (empty($services)): ?>
                    <div class="flex flex-col items-center justify-center py-16 text-center">
                        <div class="w-16 h-16 rounded-3xl bg-slate-50 flex items-center justify-center mb-3 border border-slate-100">
                            <i class="fa-solid fa-layer-group text-2xl text-slate-400"></i>
                        </div>
                        <p class="text-sm font-medium text-slate-600 mb-1">هنوز خدمتی ثبت نشده است</p>
                        <p class="text-xs text-slate-400 mb-4">برای شروع روی دکمه «افزودن خدمت جدید» بالا کلیک کنید.</p>
                        <button onclick="openAddModal()"
                                class="inline-flex items-center gap-1.5 bg-gradient-to-r from-primary-500 to-mint-500 text-white px-4 py-2 rounded-2xl text-xs font-bold shadow-card">
                            <i class="fa-solid fa-plus text-[11px]"></i>
                            افزودن اولین خدمت
                        </button>
                    </div>
                <?php else: ?>
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-6">
                        <?php foreach($services as $s): ?>
                            <div class="relative bg-white/90 rounded-3xl p-4 sm:p-5 border border-slate-100 hover:border-primary-300 shadow-[0_10px_30px_rgba(15,23,42,0.04)] hover:shadow-card transition-all overflow-hidden">
                                <!-- badge دسته‌بندی -->
                                <?php if (!empty($s['category'])): ?>
                                    <span class="absolute top-3 left-3 px-2.5 py-1 rounded-full bg-slate-900 text-[11px] text-slate-50 flex items-center gap-1.5">
                                        <i class="fa-solid fa-tag text-[9px] text-amber-300"></i>
                                        <?php echo htmlspecialchars($s['category']); ?>
                                    </span>
                                <?php endif; ?>

                                <div class="flex items-start justify-between mb-4">
                                    <div class="flex items-center gap-3">
                                        <?php if(!empty($s['icon_url'])): ?>
                                            <div class="relative">
                                                <div class="absolute -inset-1 rounded-2xl bg-primary-100/60 blur-sm"></div>
                                                <div class="relative w-12 h-12 rounded-2xl bg-slate-50 border border-slate-100 flex items-center justify-center">
                                                    <img src="../../<?php echo $s['icon_url']; ?>"
                                                         class="w-10 h-10 object-contain" alt="">
                                                </div>
                                            </div>
                                        <?php else: ?>
                                            <div class="relative">
                                                <div class="absolute -inset-1 rounded-2xl bg-primary-100/60 blur-sm opacity-70"></div>
                                                <div class="relative w-12 h-12 rounded-2xl bg-primary-50 text-primary-500 flex items-center justify-center text-xl border border-primary-100">
                                                    <i class="fa-solid <?php echo $s['icon'] ?: 'fa-box'; ?>"></i>
                                                </div>
                                            </div>
                                        <?php endif; ?>

                                        <div>
                                            <h3 class="font-bold text-slate-900 text-sm sm:text-base">
                                                <?php echo htmlspecialchars($s['name']); ?>
                                            </h3>
                                            <p class="text-xs text-slate-500 mt-1 flex items-center gap-1">
                                                <i class="fa-solid fa-coins text-[10px] text-amber-400"></i>
                                                <span class="font-semibold text-slate-800">
                                                    <?php echo number_format($s['price']); ?>
                                                </span>
                                                <span class="text-[11px] text-slate-400">تومان</span>
                                            </p>
                                        </div>
                                    </div>
                                </div>

                                <div class="flex items-center justify-between mt-3 pt-3 border-t border-slate-100">
                                    <div class="text-[11px] text-slate-400">
                                        <span>شناسه خدمت: </span>
                                        <span class="font-mono text-slate-600">#<?php echo $s['id']; ?></span>
                                    </div>
                                    <div class="flex gap-2">
                                        <button onclick='editService(<?php echo json_encode($s, JSON_UNESCAPED_UNICODE); ?>)'
                                                class="flex items-center gap-1.5 bg-primary-50 text-primary-600 px-3 py-1.5 rounded-2xl text-[11px] font-bold hover:bg-primary-500 hover:text-white transition-colors">
                                            <i class="fa-solid fa-pen text-[10px]"></i>
                                            ویرایش
                                        </button>
                                        <button onclick="deleteService(<?php echo $s['id']; ?>)"
                                                class="flex items-center justify-center w-9 h-9 rounded-2xl bg-rose-50 text-rose-500 text-xs hover:bg-rose-500 hover:text-white transition-colors">
                                            <i class="fa-solid fa-trash"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </section>
        </div>
    </main>
</div>

<!-- Modal -->
<div id="modal"
     class="fixed inset-0 bg-black/40 z-50 hidden backdrop-blur-sm flex items-center justify-center p-4">
    <div class="bg-white rounded-3xl w-full max-w-md p-5 sm:p-6 shadow-glass relative"
         onclick="event.stopPropagation()">
        <button type="button"
                onclick="closeModal()"
                class="absolute top-3 left-3 w-8 h-8 rounded-2xl bg-slate-100 text-slate-500 hover:bg-slate-200 hover:text-slate-700 flex items-center justify-center transition-colors">
            <i class="fa-solid fa-xmark text-base"></i>
        </button>

        <h3 class="text-lg sm:text-xl font-extrabold mb-4 text-slate-900 flex items-center gap-2" id="modal-title">
            افزودن خدمت جدید
        </h3>

        <form id="service-form" class="space-y-4">
            <input type="hidden" id="service-id">

            <div>
                <label class="block text-xs font-bold text-slate-600 mb-1.5">نام خدمت</label>
                <input type="text" id="service-name"
                       class="w-full px-3.5 py-2.5 rounded-2xl border border-slate-200 bg-slate-50 text-sm focus:bg-white focus:border-primary-500 focus:ring-2 focus:ring-primary-100 outline-none"
                       required>
            </div>

            <div>
                <label class="block text-xs font-bold text-slate-600 mb-1.5">قیمت (تومان)</label>
                <input type="number" id="service-price"
                       class="w-full px-3.5 py-2.5 rounded-2xl border border-slate-200 bg-slate-50 text-sm focus:bg-white focus:border-primary-500 focus:ring-2 focus:ring-primary-100 outline-none"
                       required>
            </div>

            <div>
                <label class="block text-xs font-bold text-slate-600 mb-1.5">دسته‌بندی</label>
                <input type="text" id="service-category"
                       class="w-full px-3.5 py-2.5 rounded-2xl border border-slate-200 bg-slate-50 text-sm focus:bg-white focus:border-primary-500 focus:ring-2 focus:ring-primary-100 outline-none"
                       placeholder="مثلاً: آقایان، بانوان، منزل">
            </div>

            <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                <div>
                    <label class="block text-xs font-bold text-slate-600 mb-1.5">آیکون FontAwesome</label>
                    <input type="text" id="service-icon"
                           class="w-full px-3.5 py-2.5 rounded-2xl border border-slate-200 bg-slate-50 text-sm focus:bg-white focus:border-primary-500 focus:ring-2 focus:ring-primary-100 outline-none"
                           placeholder="fa-shirt">
                    <p class="text-[10px] text-slate-400 mt-1">
                        مثال: fa-shirt, fa-bed, fa-vest
                    </p>
                </div>

                <div>
                    <label class="block text-xs font-bold text-slate-600 mb-1.5">یا آپلود تصویر (PNG/SVG)</label>
                    <input type="file" id="service-image" accept=".png,.svg"
                           class="w-full text-xs px-3.5 py-2.5 rounded-2xl border border-slate-200 bg-slate-50 focus:bg-white focus:border-primary-500 focus:ring-2 focus:ring-primary-100 outline-none">
                    <div id="current-image" class="mt-2 hidden">
                        <img id="preview-image"
                             class="w-14 h-14 object-contain border border-slate-200 rounded-2xl p-2 bg-slate-50">
                    </div>
                </div>
            </div>

            <div class="flex gap-3 pt-3">
                <button type="submit"
                        class="flex-1 bg-gradient-to-r from-primary-500 to-mint-500 text-white py-2.5 rounded-2xl text-sm font-bold hover:shadow-card transition-all">
                    <i class="fa-solid fa-check ml-2 text-xs"></i>
                    ذخیره خدمت
                </button>
                <button type="button" onclick="closeModal()"
                        class="px-4 sm:px-5 bg-slate-100 text-slate-700 py-2.5 rounded-2xl text-sm font-bold hover:bg-slate-200 transition-colors">
                    انصراف
                </button>
            </div>
        </form>
    </div>
</div>

<script src="../../js/utils.js"></script>
<script>
let editMode = false;

function openAddModal() {
    editMode = false;
    document.getElementById('modal-title').innerText = 'افزودن خدمت جدید';
    document.getElementById('service-form').reset();
    document.getElementById('service-id').value = '';
    document.getElementById('current-image').classList.add('hidden');
    const modal = document.getElementById('modal');
    modal.classList.remove('hidden');
    modal.onclick = closeModal;
}

function editService(service) {
    editMode = true;
    document.getElementById('modal-title').innerText = 'ویرایش خدمت';
    document.getElementById('service-id').value = service.id;
    document.getElementById('service-name').value = service.name;
    document.getElementById('service-price').value = service.price;
    document.getElementById('service-category').value = service.category || '';
    document.getElementById('service-icon').value = service.icon || '';

    if (service.icon_url) {
        document.getElementById('current-image').classList.remove('hidden');
        document.getElementById('preview-image').src = '../../' + service.icon_url;
    } else {
        document.getElementById('current-image').classList.add('hidden');
    }

    const modal = document.getElementById('modal');
    modal.classList.remove('hidden');
    modal.onclick = closeModal;
}

function closeModal(event) {
    if (!event || event.target.id === 'modal') {
        document.getElementById('modal').classList.add('hidden');
    }
}

document.getElementById('service-form').addEventListener('submit', async (e) => {
    e.preventDefault();

    const formData = new FormData();
    const id = document.getElementById('service-id').value;

    formData.append('name', document.getElementById('service-name').value);
    formData.append('price', document.getElementById('service-price').value);
    formData.append('category', document.getElementById('service-category').value);
    formData.append('icon', document.getElementById('service-icon').value);

    const imageFile = document.getElementById('service-image').files[0];
    if (imageFile) {
        formData.append('image', imageFile);
    }

    const url = editMode ? `../../api/services.php?id=${id}` : '../../api/services.php';

    try {
        const response = await fetch(url, {
            method: 'POST',
            body: formData
        });

        if (response.ok) {
            showToast(editMode ? 'خدمت ویرایش شد' : 'خدمت اضافه شد', 'success');
            setTimeout(() => location.reload(), 800);
        } else {
            showToast('خطا در ذخیره', 'error');
        }
    } catch (error) {
        showToast('خطا در ارتباط با سرور', 'error');
    }
});

async function deleteService(id) {
    if (!confirm('آیا از حذف این خدمت اطمینان دارید؟')) return;

    try {
        const response = await fetch(`../../api/services.php?id=${id}`, {
            method: 'DELETE'
        });

        if (response.ok) {
            showToast('خدمت حذف شد', 'success');
            setTimeout(() => location.reload(), 800);
        } else {
            showToast('خطا در حذف', 'error');
        }
    } catch (error) {
        showToast('خطا در ارتباط با سرور', 'error');
    }
}
</script>

</body>
</html>
