<?php
header('Content-Type: text/html; charset=utf-8');
session_start();
require_once '../../api/db.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: ../../login.php");
    exit();
}

$settings = [];
try {
    $result = $conn->query("SELECT setting_key, setting_value FROM settings");
    while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }
} catch (PDOException $e) {}

function safe_output($value) {
    return htmlspecialchars($value ?? '', ENT_QUOTES, 'UTF-8');
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تنظیمات | پاکشو</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@100..900&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Vazirmatn', sans-serif; }
        .glass-effect {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
        }
    </style>
</head>
<body class="bg-slate-50 text-gray-800 antialiased selection:bg-blue-100 selection:text-blue-900">
    <div class="min-h-screen flex flex-col">
        
        <!-- Header -->
        <header class="glass-effect sticky top-0 z-50 border-b border-gray-200/60 px-6 py-4 transition-all duration-300">
            <div class="max-w-6xl mx-auto flex items-center gap-5">
                <a href="admin.php" class="group relative w-12 h-12 rounded-2xl bg-white border border-gray-200 flex items-center justify-center text-gray-500 hover:text-blue-600 hover:border-blue-200 hover:shadow-lg hover:shadow-blue-500/10 transition-all duration-300">
                    <i class="fa-solid fa-arrow-right text-lg group-hover:translate-x-1 transition-transform"></i>
                </a>
                <div class="flex flex-col">
                    <h1 class="text-2xl font-black text-gray-800 tracking-tight">تنظیمات سیستم</h1>
                    <div class="flex items-center gap-2 text-xs font-medium text-gray-500 mt-1">
                        <span class="w-1.5 h-1.5 rounded-full bg-green-500 animate-pulse"></span>
                        پنل مدیریت
                    </div>
                </div>
            </div>
        </header>

        <main class="flex-1 p-6 md:p-10">
            <div class="max-w-6xl mx-auto space-y-10">
                
                <!-- Hero Section / Context -->
                <div class="bg-gradient-to-br from-blue-600 to-indigo-700 rounded-3xl p-8 text-white shadow-2xl shadow-blue-900/20 relative overflow-hidden">
                    <div class="absolute top-0 left-0 w-64 h-64 bg-white/10 rounded-full blur-3xl -translate-x-1/2 -translate-y-1/2"></div>
                    <div class="absolute bottom-0 right-0 w-64 h-64 bg-indigo-500/30 rounded-full blur-3xl translate-x-1/2 translate-y-1/2"></div>
                    
                    <div class="relative z-10 flex flex-col md:flex-row items-start md:items-center justify-between gap-4">
                        <div>
                            <h2 class="text-2xl font-bold mb-2">مرکز کنترل تنظیمات</h2>
                            <p class="text-blue-100 text-sm md:text-base opacity-90 leading-relaxed max-w-2xl">
                                برای مدیریت پیکربندی سیستم، ویرایش اطلاعات و نظارت بر عملکرد، یکی از بخش‌های زیر را انتخاب کنید.
                            </p>
                        </div>
                        <div class="w-12 h-12 bg-white/20 rounded-2xl flex items-center justify-center backdrop-blur-sm border border-white/30">
                            <i class="fa-solid fa-sliders text-xl text-white"></i>
                        </div>
                    </div>
                </div>

                <!-- Cards Grid -->
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">

                    <!-- Card 1: Business Info -->
                    <a href="settings_business.php" class="group relative bg-white p-6 rounded-3xl border border-gray-100 shadow-[0_8px_30px_rgb(0,0,0,0.04)] hover:shadow-[0_8px_30px_rgb(59,130,246,0.1)] transition-all duration-300 hover:-translate-y-1 overflow-hidden">
                        <div class="absolute top-0 right-0 w-32 h-32 bg-blue-50 rounded-bl-full -mr-10 -mt-10 transition-transform group-hover:scale-110 duration-500"></div>
                        
                        <div class="relative z-10">
                            <div class="w-14 h-14 rounded-2xl bg-blue-500 text-white flex items-center justify-center text-xl shadow-lg shadow-blue-500/30 mb-5 group-hover:scale-110 transition-transform duration-300">
                                <i class="fa-solid fa-store"></i>
                            </div>
                            
                            <h3 class="text-lg font-bold text-gray-800 mb-2 group-hover:text-blue-600 transition-colors">اطلاعات کسب‌وکار</h3>
                            <p class="text-sm text-gray-500 leading-relaxed mb-4">ویرایش نام فروشگاه، آدرس فیزیکی، شماره‌های تماس و شبکه‌های اجتماعی.</p>
                            
                            <div class="flex items-center text-xs font-bold text-blue-600 opacity-0 group-hover:opacity-100 transform translate-y-2 group-hover:translate-y-0 transition-all duration-300">
                                مشاهده و ویرایش <i class="fa-solid fa-arrow-left mr-2"></i>
                            </div>
                        </div>
                    </a>

                    <!-- Card 2: Messaging -->
                    <a href="settings_messaging.php" class="group relative bg-white p-6 rounded-3xl border border-gray-100 shadow-[0_8px_30px_rgb(0,0,0,0.04)] hover:shadow-[0_8px_30px_rgb(34,197,94,0.1)] transition-all duration-300 hover:-translate-y-1 overflow-hidden">
                        <div class="absolute top-0 right-0 w-32 h-32 bg-green-50 rounded-bl-full -mr-10 -mt-10 transition-transform group-hover:scale-110 duration-500"></div>
                        
                        <div class="relative z-10">
                            <div class="w-14 h-14 rounded-2xl bg-green-500 text-white flex items-center justify-center text-xl shadow-lg shadow-green-500/30 mb-5 group-hover:scale-110 transition-transform duration-300">
                                <i class="fa-brands fa-whatsapp"></i>
                            </div>
                            
                            <h3 class="text-lg font-bold text-gray-800 mb-2 group-hover:text-green-600 transition-colors">پیامک و واتساپ</h3>
                            <p class="text-sm text-gray-500 leading-relaxed mb-4">تنظیم درگاه‌های پیامکی، قالب‌های ارسال خودکار و اتصال به واتساپ.</p>
                            
                            <div class="flex items-center text-xs font-bold text-green-600 opacity-0 group-hover:opacity-100 transform translate-y-2 group-hover:translate-y-0 transition-all duration-300">
                                مدیریت پیام‌ها <i class="fa-solid fa-arrow-left mr-2"></i>
                            </div>
                        </div>
                    </a>

                    <!-- Card 4: System -->
                    <a href="settings_system.php" class="group relative bg-white p-6 rounded-3xl border border-gray-100 shadow-[0_8px_30px_rgb(0,0,0,0.04)] hover:shadow-[0_8px_30px_rgb(99,102,241,0.1)] transition-all duration-300 hover:-translate-y-1 overflow-hidden">
                        <div class="absolute top-0 right-0 w-32 h-32 bg-indigo-50 rounded-bl-full -mr-10 -mt-10 transition-transform group-hover:scale-110 duration-500"></div>
                        
                        <div class="relative z-10">
                            <div class="w-14 h-14 rounded-2xl bg-indigo-500 text-white flex items-center justify-center text-xl shadow-lg shadow-indigo-500/30 mb-5 group-hover:scale-110 transition-transform duration-300">
                                <i class="fa-solid fa-shield-halved"></i>
                            </div>
                            
                            <h3 class="text-lg font-bold text-gray-800 mb-2 group-hover:text-indigo-600 transition-colors">تنظیمات سیستم</h3>
                            <p class="text-sm text-gray-500 leading-relaxed mb-4">مدیریت کاربران، سطوح دسترسی، امنیت و پشتیبان‌گیری از اطلاعات.</p>
                            
                            <div class="flex items-center text-xs font-bold text-indigo-600 opacity-0 group-hover:opacity-100 transform translate-y-2 group-hover:translate-y-0 transition-all duration-300">
                                پیکربندی امنیتی <i class="fa-solid fa-arrow-left mr-2"></i>
                            </div>
                        </div>
                    </a>

                    <!-- Card 5: Reports -->
                    <a href="settings_reports.php" class="group relative bg-white p-6 rounded-3xl border border-gray-100 shadow-[0_8px_30px_rgb(0,0,0,0.04)] hover:shadow-[0_8px_30px_rgb(245,158,11,0.1)] transition-all duration-300 hover:-translate-y-1 overflow-hidden md:col-span-2 lg:col-span-1">
                        <div class="absolute top-0 right-0 w-32 h-32 bg-amber-50 rounded-bl-full -mr-10 -mt-10 transition-transform group-hover:scale-110 duration-500"></div>
                        
                        <div class="relative z-10">
                            <div class="w-14 h-14 rounded-2xl bg-amber-500 text-white flex items-center justify-center text-xl shadow-lg shadow-amber-500/30 mb-5 group-hover:scale-110 transition-transform duration-300">
                                <i class="fa-solid fa-chart-pie"></i>
                            </div>
                            
                            <h3 class="text-lg font-bold text-gray-800 mb-2 group-hover:text-amber-600 transition-colors">گزارش‌گیری و آمار</h3>
                            <p class="text-sm text-gray-500 leading-relaxed mb-4">مشاهده نمودارهای فروش، تحلیل عملکرد و خروجی اکسل.</p>
                            
                            <div class="flex items-center text-xs font-bold text-amber-600 opacity-0 group-hover:opacity-100 transform translate-y-2 group-hover:translate-y-0 transition-all duration-300">
                                مشاهده آمار <i class="fa-solid fa-arrow-left mr-2"></i>
                            </div>
                        </div>
                    </a>

                </div>
            </div>
        </main>
    </div>
</body>
</html>
