<?php
header('Content-Type: application/json');

function jalali_to_gregorian($jy, $jm, $jd) {
    $jy += 1595;
    $days = 365 * $jy + floor($jy / 33) * 8 + floor((($jy % 33) + 3) / 4) + 78 + $jd + (($jm < 7) ? ($jm - 1) * 31 : (($jm - 7) * 30) + 186);
    $gy = 400 * floor($days / 146097);
    $days %= 146097;
    $leap = true;
    if ($days >= 36525) {
        $days--;
        $gy += 100 * floor($days / 36524);
        $days %= 36524;
        if ($days >= 365) $days++;
        else $leap = false;
    }
    $gy += 4 * floor($days / 1461);
    $days %= 1461;
    if ($days >= 366) {
        $leap = false;
        $days--;
        $gy += floor($days / 365);
        $days %= 365;
    }
    $sal_a = [0, 31, ($leap ? 60 : 59), 90, 120, 151, 181, 212, 243, 273, 304, 334];
    for ($gm = 0; $gm < 13 && $days >= $sal_a[$gm]; $gm++);
    $gm--;
    $gd = $days - $sal_a[$gm] + 1;
    return [$gy, $gm + 1, $gd];
}

$jy = intval($_GET['jy']);
$jm = intval($_GET['jm']);
$jd = intval($_GET['jd']);

list($gy, $gm, $gd) = jalali_to_gregorian($jy, $jm, $jd);
$timestamp = mktime(0, 0, 0, $gm, $gd, $gy);
$dayOfWeek = date('w', $timestamp);

echo json_encode([
    'gy' => $gy,
    'gm' => $gm,
    'gd' => $gd,
    'dayOfWeek' => $dayOfWeek
]);
