<?php
session_start();
header('Content-Type: application/json; charset=utf-8');
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Pragma: no-cache");

require_once 'db.php';
require_once 'persian_date.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    http_response_code(401);
    exit(json_encode(['error' => 'Unauthorized']));
}

try {
    $orders = $conn->query("SELECT * FROM orders ORDER BY created_at DESC")->fetchAll(PDO::FETCH_ASSOC);
    
    foreach($orders as &$o) {
        $ts = $o['created_at'] > 10000000000 ? $o['created_at'] / 1000 : $o['created_at'];
        $o['created_at_persian'] = getPersianDate('Y/m/d', $ts);
        
        if (!empty($o['delivery_date'])) {
            if (is_numeric($o['delivery_date'])) {
                $delivery_ts = $o['delivery_date'] > 10000000000 ? $o['delivery_date'] / 1000 : $o['delivery_date'];
                $o['delivery_date_persian'] = getPersianDate('Y/m/d', $delivery_ts);
            } else {
                $o['delivery_date_persian'] = $o['delivery_date'];
            }
        } else {
            $o['delivery_date_persian'] = null;
        }
    }
    
    echo json_encode(['orders' => $orders]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error']);
}
