<?php
session_start();
header("Content-Type: application/json; charset=UTF-8");
require_once 'db.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    http_response_code(403);
    echo json_encode(['error' => 'Unauthorized']);
    exit();
}

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'POST') {
    $data = json_decode(file_get_contents("php://input"), true);
    $pageName = $data['page_name'] ?? 'home';
    $content = json_encode($data['content']);
    
    try {
        // Create table if not exists
        $conn->exec("CREATE TABLE IF NOT EXISTS page_builder (
            id INT AUTO_INCREMENT PRIMARY KEY,
            page_name VARCHAR(50) UNIQUE,
            content LONGTEXT,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        )");
        
        // Insert or update
        $stmt = $conn->prepare("INSERT INTO page_builder (page_name, content) VALUES (?, ?) 
                                ON DUPLICATE KEY UPDATE content = ?");
        $stmt->execute([$pageName, $content, $content]);
        
        echo json_encode(['success' => true]);
    } catch(PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => $e->getMessage()]);
    }
}
?>
