<?php
header('Content-Type: application/json; charset=utf-8');

class PersianCalendar {
    
    public static function gregorianToJalali($gy, $gm, $gd) {
        $g_d_m = [0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334];
        $gy2 = ($gm > 2) ? ($gy + 1) : $gy;
        $days = 355666 + (365 * $gy) + floor(($gy2 + 3) / 4) - floor(($gy2 + 99) / 100) + floor(($gy2 + 399) / 400) + $gd + $g_d_m[$gm - 1];
        $jy = -1595 + (33 * floor($days / 12053));
        $days %= 12053;
        $jy += 4 * floor($days / 1461);
        $days %= 1461;
        if ($days > 365) {
            $jy += floor(($days - 1) / 365);
            $days = ($days - 1) % 365;
        }
        $jm = ($days < 186) ? 1 + floor($days / 31) : 7 + floor(($days - 186) / 30);
        $jd = 1 + (($days < 186) ? ($days % 31) : (($days - 186) % 30));
        return [$jy, $jm, $jd];
    }
    
    public static function jalaliToGregorian($jy, $jm, $jd) {
        $jy += 1595;
        $days = 365 * $jy + floor($jy / 33) * 8 + floor(($jy % 33 + 3) / 4) + 78 + $jd + (($jm < 7) ? ($jm - 1) * 31 : (($jm - 7) * 30) + 186);
        $gy = 400 * floor($days / 146097);
        $days %= 146097;
        $flag = true;
        if ($days >= 36525) {
            $days--;
            $gy += 100 * floor($days / 36524);
            $days %= 36524;
            if ($days >= 365) $days++;
            else $flag = false;
        }
        if ($flag) {
            $gy += 4 * floor($days / 1461);
            $days %= 1461;
            if ($days >= 366) {
                $flag = false;
                $days--;
                $gy += floor($days / 365);
                $days = $days % 365;
            }
        }
        $sal_a = [0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334];
        foreach ($sal_a as $i => $v) {
            if ($i < 11 && $days < $sal_a[$i + 1]) {
                $gm = $i + 1;
                break;
            } elseif ($i == 11) {
                $gm = 12;
            }
        }
        $gd = $days - $sal_a[$gm - 1] + 1;
        return [$gy, $gm, $gd];
    }
    
    public static function getCalendar($year, $month) {
        $daysInMonth = $month < 7 ? 31 : ($month < 12 ? 30 : 29);
        $gDate = self::jalaliToGregorian($year, $month, 1);
        $timestamp = mktime(0, 0, 0, $gDate[1], $gDate[2], $gDate[0]);
        $dayOfWeek = date('w', $timestamp);
        
        // تبدیل به تقویم شمسی: شنبه=0
        $firstDayOffset = ($dayOfWeek + 1) % 7;
        
        $today = self::gregorianToJalali(date('Y'), date('m'), date('d'));
        
        $days = [];
        
        // خانه‌های خالی قبل از روز اول
        for ($i = 0; $i < $firstDayOffset; $i++) {
            $days[] = ['day' => '', 'currentMonth' => false];
        }
        
        // روزهای ماه
        for ($i = 1; $i <= $daysInMonth; $i++) {
            $dateStr = sprintf('%d/%02d/%02d', $year, $month, $i);
            $isPast = ($year < $today[0]) || 
                      ($year == $today[0] && $month < $today[1]) ||
                      ($year == $today[0] && $month == $today[1] && $i < $today[2]);
            $isToday = ($year == $today[0] && $month == $today[1] && $i == $today[2]);
            
            $days[] = [
                'day' => $i,
                'date' => $dateStr,
                'currentMonth' => true,
                'isToday' => $isToday,
                'disabled' => $isPast
            ];
        }
        
        return [
            'year' => $year,
            'month' => $month,
            'days' => $days,
            'firstDayOffset' => $firstDayOffset
        ];
    }
}

// API Endpoint
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $year = isset($_GET['year']) ? intval($_GET['year']) : self::gregorianToJalali(date('Y'), date('m'), date('d'))[0];
    $month = isset($_GET['month']) ? intval($_GET['month']) : self::gregorianToJalali(date('Y'), date('m'), date('d'))[1];
    
    echo json_encode(PersianCalendar::getCalendar($year, $month), JSON_UNESCAPED_UNICODE);
}
