<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET,POST,PUT,PATCH,DELETE,OPTIONS");
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') { http_response_code(200); exit(); }

include_once 'db.php';

$method = $_SERVER['REQUEST_METHOD'];

if ($method == 'GET') {
    try {
        $query = "SELECT * FROM services ORDER BY id DESC";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        $services = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        foreach($services as &$item) {
            $item['price'] = (float)$item['price'];
            $item['id'] = (int)$item['id'];
        }

        echo json_encode(['data' => $services]);
    } catch(PDOException $e) {
        http_response_code(500);
        echo json_encode(["message" => $e->getMessage()]);
    }

} elseif ($method == 'POST') {
    // Create or Update Service
    $id = $_GET['id'] ?? null;
    $name = $_POST['name'] ?? '';
    $price = $_POST['price'] ?? 0;
    $category = $_POST['category'] ?? '';
    $icon = $_POST['icon'] ?? 'fa-box';
    $icon_url = null;

    // Handle Image Upload
    if(isset($_FILES['image']) && $_FILES['image']['error'] == 0) {
        $allowed = ['png', 'svg'];
        $filename = $_FILES['image']['name'];
        $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
        
        if(in_array($ext, $allowed)) {
            $upload_dir = '../uploads/services/';
            if(!is_dir($upload_dir)) mkdir($upload_dir, 0777, true);
            
            $new_filename = uniqid() . '.' . $ext;
            $upload_path = $upload_dir . $new_filename;
            
            if(move_uploaded_file($_FILES['image']['tmp_name'], $upload_path)) {
                $icon_url = 'uploads/services/' . $new_filename;
            }
        }
    }

    try {
        if($id) {
            // Update
            $query = "UPDATE services SET name=:name, price=:price, category=:category, icon=:icon";
            if($icon_url) $query .= ", icon_url=:icon_url";
            $query .= " WHERE id=:id";
            
            $stmt = $conn->prepare($query);
            $stmt->bindParam(':name', $name);
            $stmt->bindParam(':price', $price);
            $stmt->bindParam(':category', $category);
            $stmt->bindParam(':icon', $icon);
            $stmt->bindParam(':id', $id);
            if($icon_url) $stmt->bindParam(':icon_url', $icon_url);
        } else {
            // Create
            $query = "INSERT INTO services (name, price, category, icon, icon_url) VALUES (:name, :price, :category, :icon, :icon_url)";
            $stmt = $conn->prepare($query);
            $stmt->bindParam(':name', $name);
            $stmt->bindParam(':price', $price);
            $stmt->bindParam(':category', $category);
            $stmt->bindParam(':icon', $icon);
            $stmt->bindParam(':icon_url', $icon_url);
        }
        
        $stmt->execute();
        echo json_encode(['message' => 'Success']);
    } catch(PDOException $e) {
        http_response_code(500);
        echo json_encode(["message" => $e->getMessage()]);
    }

} elseif ($method == 'DELETE') {
    $id = $_GET['id'] ?? null;
    
    if(!$id) {
        http_response_code(400);
        echo json_encode(["message" => "ID required"]);
        exit();
    }

    try {
        // Delete image file if exists
        $stmt = $conn->prepare("SELECT icon_url FROM services WHERE id=:id");
        $stmt->bindParam(':id', $id);
        $stmt->execute();
        $service = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if($service && $service['icon_url'] && file_exists('../' . $service['icon_url'])) {
            unlink('../' . $service['icon_url']);
        }

        $stmt = $conn->prepare("DELETE FROM services WHERE id=:id");
        $stmt->bindParam(':id', $id);
        $stmt->execute();
        
        echo json_encode(['message' => 'Deleted']);
    } catch(PDOException $e) {
        http_response_code(500);
        echo json_encode(["message" => $e->getMessage()]);
    }

} else {
    http_response_code(405);
    echo json_encode(["message" => "Method not allowed"]);
}
?>
