# سرور لایسنس - راهنمای نصب

## نصب سرور لایسنس (روی دامنه جداگانه)

### مرحله 1: آپلود فایلها
پوشه `LICENSE_SERVER` را روی دامنه جداگانه آپلود کنید:
```
https://license.yourserver.com/
```

### مرحله 2: تنظیمات
فایل `api.php` را باز کنید و کلیدها را تغییر دهید:
```php
define('API_KEY', 'YOUR_UNIQUE_API_KEY');
define('ENCRYPT_KEY', 'YOUR_UNIQUE_ENCRYPT_KEY');
```

فایل `index.php` را باز کنید و رمز عبور را تغییر دهید:
```php
$pass = 'YOUR_ADMIN_PASSWORD';
```

### مرحله 3: دسترسی
```
پنل مدیریت: https://license.yourserver.com/
رمز عبور: admin@license2024 (تغییر دهید!)
```

---

## تنظیمات پروژه اصلی (بلوار)

### مرحله 1: تنظیم آدرس سرور
فایل `includes/license.php` را باز کنید:
```php
private static $serverUrl = 'https://license.yourserver.com/api.php';
```

### مرحله 2: تست
```
http://localhost/bolvar/license_activate.php
```

---

## نحوه استفاده

### برای فروشنده:
1. وارد پنل سرور لایسنس شوید
2. دامنه مشتری را وارد کنید (مثلا: customer.com)
3. کد لایسنس را کپی و به مشتری بدهید

### برای مشتری:
1. پروژه را روی هاست نصب کنید
2. سایت را باز کنید → ریدایرکت به صفحه فعالسازی
3. کد لایسنس را وارد کنید
4. فعالسازی موفق ✅

---

## امنیت

✅ سرور لایسنس روی دامنه جداگانه
✅ رمزنگاری AES-256-CBC
✅ API Key محافظت شده
✅ بررسی دامنه و IP
✅ محدودیت تعداد فعالسازی
✅ تاریخ انقضا

---

## API Endpoints

```
POST /api.php?action=generate
POST /api.php?action=activate
POST /api.php?action=verify
POST /api.php?action=deactivate
```

---

## پشتیبانی

در صورت بروز مشکل، فایل `licenses.json` را بررسی کنید.
