<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

define('API_KEY', 'BoLvAr_API_2024_@#$%^&*');
define('ENCRYPT_KEY', 'BoLvAr_EnCrYpT_2024_!@#');

$db = __DIR__ . '/licenses.json';

class LicenseAPI {
    
    public static function generate($data) {
        if (!self::auth($data['api_key'] ?? '')) {
            return ['success' => false, 'message' => 'کلید API نامعتبر'];
        }
        
        $domain = trim($data['domain'] ?? '');
        if (!$domain) return ['success' => false, 'message' => 'دامنه الزامی است'];
        
        $lic = [
            'id' => 'LIC-' . strtoupper(bin2hex(random_bytes(8))),
            'key' => self::genKey(),
            'domain' => $domain,
            'ip' => trim($data['server_ip'] ?? '') ?: null,
            'issued' => time(),
            'expire' => isset($data['expire_days']) ? time() + ($data['expire_days'] * 86400) : null,
            'status' => 'active',
            'activations' => 0,
            'max_activations' => 1
        ];
        
        self::save($lic);
        
        $code = base64_encode(self::encrypt(json_encode($lic)));
        
        return [
            'success' => true,
            'license' => [
                'code' => $code,
                'key' => $lic['key'],
                'domain' => $lic['domain']
            ]
        ];
    }
    
    public static function activate($data) {
        $code = trim($data['license_code'] ?? '');
        $domain = trim($data['domain'] ?? '');
        $ip = trim($data['server_ip'] ?? '');
        
        if (!$code || !$domain) {
            return ['success' => false, 'message' => 'اطلاعات ناقص'];
        }
        
        $dec = self::decrypt(base64_decode($code));
        if (!$dec) return ['success' => false, 'message' => 'کد نامعتبر'];
        
        $lic = json_decode($dec, true);
        
        if ($lic['domain'] !== $domain && $lic['domain'] !== '*') {
            return ['success' => false, 'message' => 'دامنه مطابقت ندارد'];
        }
        
        if ($lic['ip'] && $lic['ip'] !== $ip) {
            return ['success' => false, 'message' => 'IP مطابقت ندارد'];
        }
        
        if ($lic['expire'] && time() > $lic['expire']) {
            return ['success' => false, 'message' => 'لایسنس منقضی شده'];
        }
        
        $stored = self::get($lic['id']);
        if ($stored && $stored['activations'] >= $stored['max_activations']) {
            return ['success' => false, 'message' => 'قبلاً فعال شده'];
        }
        
        if ($stored) {
            $stored['activations']++;
            $stored['last_activation'] = time();
            self::update($stored);
        }
        
        return ['success' => true, 'message' => 'فعال شد', 'license' => $lic];
    }
    
    public static function verify($data) {
        $key = trim($data['license_key'] ?? '');
        $domain = trim($data['domain'] ?? '');
        
        if (!$key || !$domain) {
            return ['valid' => false, 'message' => 'اطلاعات ناقص'];
        }
        
        $lic = self::getByKey($key);
        
        if (!$lic) return ['valid' => false, 'message' => 'یافت نشد'];
        if ($lic['status'] !== 'active') return ['valid' => false, 'message' => 'غیرفعال'];
        if ($lic['domain'] !== $domain && $lic['domain'] !== '*') return ['valid' => false, 'message' => 'دامنه نامعتبر'];
        if ($lic['expire'] && time() > $lic['expire']) return ['valid' => false, 'message' => 'منقضی شده'];
        
        return ['valid' => true, 'message' => 'معتبر'];
    }
    
    public static function deactivate($data) {
        if (!self::auth($data['api_key'] ?? '')) {
            return ['success' => false, 'message' => 'کلید API نامعتبر'];
        }
        
        $key = trim($data['license_key'] ?? '');
        $lic = self::getByKey($key);
        
        if (!$lic) return ['success' => false, 'message' => 'یافت نشد'];
        
        $lic['status'] = 'deactivated';
        self::update($lic);
        
        return ['success' => true, 'message' => 'غیرفعال شد'];
    }
    
    private static function auth($key) {
        return hash_equals(API_KEY, $key);
    }
    
    private static function genKey() {
        return strtoupper(substr(md5(uniqid(rand(), true)), 0, 8) . '-' . 
                         substr(md5(uniqid(rand(), true)), 0, 8) . '-' . 
                         substr(md5(uniqid(rand(), true)), 0, 8));
    }
    
    private static function encrypt($data) {
        $iv = openssl_random_pseudo_bytes(16);
        $enc = openssl_encrypt($data, 'AES-256-CBC', ENCRYPT_KEY, 0, $iv);
        return $iv . $enc;
    }
    
    private static function decrypt($data) {
        $iv = substr($data, 0, 16);
        $enc = substr($data, 16);
        return openssl_decrypt($enc, 'AES-256-CBC', ENCRYPT_KEY, 0, $iv);
    }
    
    private static function save($lic) {
        global $db;
        $all = self::getAll();
        $all[$lic['id']] = $lic;
        file_put_contents($db, json_encode($all, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    }
    
    private static function update($lic) {
        self::save($lic);
    }
    
    private static function get($id) {
        $all = self::getAll();
        return $all[$id] ?? null;
    }
    
    private static function getByKey($key) {
        foreach (self::getAll() as $lic) {
            if ($lic['key'] === $key) return $lic;
        }
        return null;
    }
    
    private static function getAll() {
        global $db;
        if (!file_exists($db)) return [];
        return json_decode(file_get_contents($db), true) ?: [];
    }
}

$action = $_GET['action'] ?? '';
$input = json_decode(file_get_contents('php://input'), true);

switch ($action) {
    case 'generate':
        $res = LicenseAPI::generate($input);
        break;
    case 'activate':
        $res = LicenseAPI::activate($input);
        break;
    case 'verify':
        $res = LicenseAPI::verify($input);
        break;
    case 'deactivate':
        $res = LicenseAPI::deactivate($input);
        break;
    default:
        $res = ['success' => false, 'message' => 'عملیات نامعتبر'];
}

echo json_encode($res, JSON_UNESCAPED_UNICODE);
?>
