<?php
session_start();

$pass = 'admin@license2024';
$apiKey = 'BoLvAr_API_2024_@#$%^&*';
$apiUrl = 'http://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . '/api.php';

$auth = isset($_SESSION['admin']);
$result = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['pass'])) {
        if ($_POST['pass'] === $pass) {
            $_SESSION['admin'] = true;
            header('Location: index.php');
            exit;
        }
    } elseif ($auth) {
        $action = $_POST['action'] ?? '';
        
        if ($action === 'generate') {
            $result = call($apiUrl . '?action=generate', [
                'api_key' => $apiKey,
                'domain' => trim($_POST['domain'] ?? ''),
                'expire_days' => !empty($_POST['expire_days']) ? (int)$_POST['expire_days'] : null,
                'server_ip' => trim($_POST['server_ip'] ?? '')
            ]);
        } elseif ($action === 'deactivate') {
            $result = call($apiUrl . '?action=deactivate', [
                'api_key' => $apiKey,
                'license_key' => trim($_POST['license_key'] ?? '')
            ]);
        }
    }
}

function call($url, $data) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    $res = curl_exec($ch);
    curl_close($ch);
    return json_decode($res, true);
}

$licenses = [];
if ($auth && file_exists('licenses.json')) {
    $licenses = json_decode(file_get_contents('licenses.json'), true) ?: [];
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>سرور لایسنس</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;600;700&display=swap');
        * { font-family: 'Vazirmatn', sans-serif; }
        .gradient-bg { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
    </style>
</head>
<body class="bg-gray-50">

<?php if (!$auth): ?>
<div class="min-h-screen flex items-center justify-center p-4">
    <div class="max-w-md w-full bg-white rounded-2xl shadow-2xl p-8">
        <div class="text-center mb-6">
            <div class="w-16 h-16 gradient-bg rounded-full flex items-center justify-center mx-auto mb-4">
                <i class="fas fa-server text-white text-2xl"></i>
            </div>
            <h1 class="text-2xl font-bold">سرور لایسنس</h1>
        </div>
        <form method="POST">
            <input type="password" name="pass" required placeholder="رمز عبور"
                   class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-purple-500 focus:outline-none mb-4">
            <button type="submit" class="w-full gradient-bg text-white px-6 py-3 rounded-xl font-bold">
                ورود
            </button>
        </form>
    </div>
</div>

<?php else: ?>
<div class="min-h-screen">
    <div class="gradient-bg text-white py-6">
        <div class="container mx-auto px-4 flex justify-between items-center">
            <h1 class="text-2xl font-bold">سرور لایسنس</h1>
            <a href="?logout=1" onclick="<?php session_destroy(); ?>" class="bg-white/20 px-4 py-2 rounded-lg">خروج</a>
        </div>
    </div>
    
    <div class="container mx-auto px-4 py-8">
        <div class="grid lg:grid-cols-3 gap-6">
            
            <div>
                <div class="bg-white rounded-2xl shadow-xl p-6">
                    <h2 class="text-xl font-bold mb-4">تولید لایسنس</h2>
                    
                    <?php if ($result && isset($result['license'])): ?>
                    <div class="mb-4 bg-green-50 border-2 border-green-200 rounded-xl p-4">
                        <p class="text-green-800 font-bold mb-2">✅ ایجاد شد</p>
                        <textarea readonly onclick="this.select()" class="w-full bg-white p-2 rounded text-xs" rows="4"><?= $result['license']['code'] ?></textarea>
                        <button onclick="navigator.clipboard.writeText(this.previousElementSibling.value)" 
                                class="mt-2 w-full bg-green-600 text-white px-3 py-2 rounded text-xs">
                            کپی
                        </button>
                    </div>
                    <?php endif; ?>
                    
                    <form method="POST" class="space-y-4">
                        <input type="hidden" name="action" value="generate">
                        <input type="text" name="domain" required placeholder="example.com"
                               class="w-full px-4 py-2 border-2 border-gray-200 rounded-lg focus:border-purple-500 focus:outline-none">
                        <input type="number" name="expire_days" placeholder="365 (نامحدود)"
                               class="w-full px-4 py-2 border-2 border-gray-200 rounded-lg focus:border-purple-500 focus:outline-none">
                        <input type="text" name="server_ip" placeholder="IP (اختیاری)"
                               class="w-full px-4 py-2 border-2 border-gray-200 rounded-lg focus:border-purple-500 focus:outline-none">
                        <button type="submit" class="w-full gradient-bg text-white px-6 py-3 rounded-xl font-bold">
                            تولید
                        </button>
                    </form>
                </div>
            </div>
            
            <div class="lg:col-span-2">
                <div class="bg-white rounded-2xl shadow-xl p-6">
                    <h2 class="text-xl font-bold mb-4">لیست (<?= count($licenses) ?>)</h2>
                    <div class="overflow-x-auto">
                        <table class="w-full text-sm">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-4 py-3 text-right">کلید</th>
                                    <th class="px-4 py-3 text-right">دامنه</th>
                                    <th class="px-4 py-3 text-right">وضعیت</th>
                                    <th class="px-4 py-3 text-right">فعالسازی</th>
                                    <th class="px-4 py-3 text-right">عملیات</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($licenses as $lic): ?>
                                <tr class="border-t">
                                    <td class="px-4 py-3"><code class="text-xs"><?= substr($lic['key'], 0, 15) ?>...</code></td>
                                    <td class="px-4 py-3"><?= htmlspecialchars($lic['domain']) ?></td>
                                    <td class="px-4 py-3">
                                        <?php if ($lic['status'] === 'active'): ?>
                                        <span class="px-2 py-1 bg-green-100 text-green-700 rounded text-xs">فعال</span>
                                        <?php else: ?>
                                        <span class="px-2 py-1 bg-red-100 text-red-700 rounded text-xs">غیرفعال</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-4 py-3"><?= $lic['activations'] ?> / <?= $lic['max_activations'] ?></td>
                                    <td class="px-4 py-3">
                                        <?php if ($lic['status'] === 'active'): ?>
                                        <form method="POST" class="inline">
                                            <input type="hidden" name="action" value="deactivate">
                                            <input type="hidden" name="license_key" value="<?= $lic['key'] ?>">
                                            <button type="submit" class="text-red-600"><i class="fas fa-ban"></i></button>
                                        </form>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                
                <div class="mt-6 bg-blue-50 rounded-2xl p-6">
                    <h3 class="font-bold mb-3">اطلاعات API</h3>
                    <div class="space-y-2 text-sm">
                        <div>
                            <span class="text-gray-600">URL:</span>
                            <code class="block bg-white p-2 rounded mt-1 text-xs"><?= $apiUrl ?></code>
                        </div>
                        <div>
                            <span class="text-gray-600">API Key:</span>
                            <code class="block bg-white p-2 rounded mt-1 text-xs"><?= $apiKey ?></code>
                        </div>
                    </div>
                </div>
            </div>
            
        </div>
    </div>
</div>
<?php endif; ?>

</body>
</html>
