<?php
header('Content-Type: text/html; charset=utf-8');
session_start();
require_once '../../api/db.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: ../../login.php");
    exit();
}

$settings = [];
try {
    $result = $conn->query("SELECT setting_key, setting_value FROM settings");
    while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }
} catch (PDOException $e) {}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $keys = ['business_name', 'business_phone', 'business_address', 'working_hours', 'invoice_message'];
    
    try {
        foreach ($keys as $key) {
            $value = $_POST[$key] ?? '';
            $stmt = $conn->prepare("INSERT INTO settings (setting_key, setting_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE setting_value = ?");
            $stmt->execute([$key, $value, $value]);
        }
        header("Location: settings_business.php?success=1");
        exit();
    } catch (PDOException $e) {
        $error = true;
    }
}

function safe_output($value) {
    return htmlspecialchars($value ?? '', ENT_QUOTES, 'UTF-8');
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>اطلاعات کسب‌وکار | پاکشو</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@100..900&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Vazirmatn', sans-serif; }
        .input-group:focus-within label { color: #2563eb; }
        .input-group:focus-within i { color: #2563eb; }
    </style>
</head>
<body class="bg-slate-50 text-gray-800 antialiased">
    <div class="min-h-screen flex flex-col">
        
        <!-- Header -->
        <header class="bg-white/80 backdrop-blur-md border-b border-gray-200 sticky top-0 z-50 px-6 py-4">
            <div class="max-w-5xl mx-auto flex items-center gap-5">
                <a href="settings.php" class="w-10 h-10 rounded-xl bg-gray-50 border border-gray-200 hover:bg-white hover:border-blue-300 hover:text-blue-600 hover:shadow-md transition-all duration-300 flex items-center justify-center text-gray-500">
                    <i class="fa-solid fa-arrow-right"></i>
                </a>
                <div>
                    <h1 class="text-xl font-bold text-gray-800">اطلاعات کسب‌وکار</h1>
                    <p class="text-xs text-gray-500 mt-0.5">مدیریت هویت و راه‌های ارتباطی</p>
                </div>
            </div>
        </header>

        <main class="flex-1 p-6 md:p-8">
            <div class="max-w-5xl mx-auto">
                
                <!-- Alerts -->
                <?php if (isset($_GET['success'])): ?>
                <div class="mb-8 p-4 bg-emerald-50 border-r-4 border-emerald-500 rounded-lg shadow-sm flex items-center gap-3 animate-fade-in-down">
                    <div class="w-8 h-8 rounded-full bg-emerald-100 flex items-center justify-center text-emerald-600">
                        <i class="fa-solid fa-check"></i>
                    </div>
                    <div>
                        <h3 class="font-bold text-emerald-800 text-sm">تغییرات ذخیره شد</h3>
                        <p class="text-xs text-emerald-600">اطلاعات کسب‌وکار با موفقیت بروزرسانی گردید.</p>
                    </div>
                </div>
                <?php endif; ?>

                <?php if (isset($error)): ?>
                <div class="mb-8 p-4 bg-rose-50 border-r-4 border-rose-500 rounded-lg shadow-sm flex items-center gap-3 animate-fade-in-down">
                    <div class="w-8 h-8 rounded-full bg-rose-100 flex items-center justify-center text-rose-600">
                        <i class="fa-solid fa-circle-exclamation"></i>
                    </div>
                    <div>
                        <h3 class="font-bold text-rose-800 text-sm">خطا در عملیات</h3>
                        <p class="text-xs text-rose-600">مشکلی در ذخیره اطلاعات پیش آمده است.</p>
                    </div>
                </div>
                <?php endif; ?>

                <form method="POST" class="space-y-6">
                    
                    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                        
                        <!-- Left Column: Core Info & Contact -->
                        <div class="lg:col-span-2 space-y-6">
                            
                            <!-- Card 1: Identity -->
                            <div class="bg-white rounded-2xl border border-gray-200 shadow-[0_2px_15px_-3px_rgba(0,0,0,0.07),0_10px_20px_-2px_rgba(0,0,0,0.04)] overflow-hidden">
                                <div class="bg-gray-50/50 px-6 py-4 border-b border-gray-100 flex items-center gap-3">
                                    <div class="w-8 h-8 rounded-lg bg-blue-100 text-blue-600 flex items-center justify-center text-sm">
                                        <i class="fa-solid fa-id-card"></i>
                                    </div>
                                    <h3 class="font-bold text-gray-800">هویت فروشگاه</h3>
                                </div>
                                <div class="p-6 grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div class="input-group">
                                        <label class="block text-sm font-semibold text-gray-600 mb-2 transition-colors">نام کسب‌وکار</label>
                                        <div class="relative">
                                            <span class="absolute right-4 top-3.5 text-gray-400 transition-colors"><i class="fa-solid fa-store"></i></span>
                                            <input type="text" name="business_name" value="<?php echo safe_output($settings['business_name'] ?? 'پاکشو'); ?>" required 
                                                class="w-full pr-10 pl-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:bg-white focus:border-blue-500 focus:ring-4 focus:ring-blue-500/10 transition-all outline-none">
                                        </div>
                                    </div>
                                    <div class="input-group">
                                        <label class="block text-sm font-semibold text-gray-600 mb-2 transition-colors">شماره تماس</label>
                                        <div class="relative">
                                            <span class="absolute right-4 top-3.5 text-gray-400 transition-colors"><i class="fa-solid fa-phone-flip"></i></span>
                                            <input type="tel" name="business_phone" value="<?php echo safe_output($settings['business_phone'] ?? ''); ?>" dir="ltr" 
                                                class="w-full pr-10 pl-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:bg-white focus:border-blue-500 focus:ring-4 focus:ring-blue-500/10 transition-all outline-none text-right placeholder-gray-400">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Card 2: Location & Time -->
                            <div class="bg-white rounded-2xl border border-gray-200 shadow-[0_2px_15px_-3px_rgba(0,0,0,0.07),0_10px_20px_-2px_rgba(0,0,0,0.04)] overflow-hidden">
                                <div class="bg-gray-50/50 px-6 py-4 border-b border-gray-100 flex items-center gap-3">
                                    <div class="w-8 h-8 rounded-lg bg-amber-100 text-amber-600 flex items-center justify-center text-sm">
                                        <i class="fa-solid fa-map-location-dot"></i>
                                    </div>
                                    <h3 class="font-bold text-gray-800">موقعیت و زمان</h3>
                                </div>
                                <div class="p-6 space-y-6">
                                    <div class="input-group">
                                        <label class="block text-sm font-semibold text-gray-600 mb-2 transition-colors">آدرس کامل</label>
                                        <div class="relative">
                                            <span class="absolute right-4 top-3.5 text-gray-400 transition-colors"><i class="fa-solid fa-location-dot"></i></span>
                                            <textarea name="business_address" rows="2" 
                                                class="w-full pr-10 pl-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:bg-white focus:border-blue-500 focus:ring-4 focus:ring-blue-500/10 transition-all outline-none resize-none"><?php echo safe_output($settings['business_address'] ?? ''); ?></textarea>
                                        </div>
                                    </div>
                                    <div class="input-group">
                                        <label class="block text-sm font-semibold text-gray-600 mb-2 transition-colors">ساعات کاری</label>
                                        <div class="relative">
                                            <span class="absolute right-4 top-3.5 text-gray-400 transition-colors"><i class="fa-regular fa-clock"></i></span>
                                            <input type="text" name="working_hours" value="<?php echo safe_output($settings['working_hours'] ?? 'شنبه تا پنجشنبه: 9 صبح تا 9 شب'); ?>" 
                                                class="w-full pr-10 pl-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:bg-white focus:border-blue-500 focus:ring-4 focus:ring-blue-500/10 transition-all outline-none">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Right Column: Invoice Settings & Submit -->
                        <div class="space-y-6">
                            
                            <!-- Card 3: Invoice Settings -->
                            <div class="bg-white rounded-2xl border border-gray-200 shadow-[0_2px_15px_-3px_rgba(0,0,0,0.07),0_10px_20px_-2px_rgba(0,0,0,0.04)] overflow-hidden">
                                <div class="bg-gray-50/50 px-6 py-4 border-b border-gray-100 flex items-center gap-3">
                                    <div class="w-8 h-8 rounded-lg bg-purple-100 text-purple-600 flex items-center justify-center text-sm">
                                        <i class="fa-solid fa-receipt"></i>
                                    </div>
                                    <h3 class="font-bold text-gray-800">تنظیمات فاکتور</h3>
                                </div>
                                <div class="p-6">
                                    <div class="input-group">
                                        <label class="block text-sm font-semibold text-gray-600 mb-2 transition-colors">پیام انتهای فاکتور</label>
                                        <div class="relative">
                                            <textarea name="invoice_message" rows="6" 
                                                class="w-full p-4 bg-gray-50 border border-gray-200 rounded-xl focus:bg-white focus:border-blue-500 focus:ring-4 focus:ring-blue-500/10 transition-all outline-none text-sm leading-relaxed"><?php echo safe_output($settings['invoice_message'] ?? 'از اعتماد شما سپاسگزاریم'); ?></textarea>
                                        </div>
                                        <p class="text-xs text-gray-400 mt-2 pr-1">این متن در پایین تمامی فاکتورهای چاپی و دیجیتال نمایش داده می‌شود.</p>
                                    </div>
                                </div>
                            </div>

                            <!-- Submit Action -->
                            <div class="bg-white rounded-2xl border border-gray-200 p-4 shadow-sm sticky top-24">
                                <button type="submit" class="group w-full py-4 bg-gradient-to-r from-blue-600 to-indigo-600 hover:from-blue-700 hover:to-indigo-700 text-white font-bold rounded-xl shadow-lg shadow-blue-500/30 transition-all duration-300 transform hover:-translate-y-0.5 active:translate-y-0">
                                    <span class="flex items-center justify-center gap-2">
                                        <i class="fa-solid fa-floppy-disk group-hover:animate-bounce"></i>
                                        ذخیره تغییرات
                                    </span>
                                </button>
                                <p class="text-center text-xs text-gray-400 mt-3">آخرین تغییرات بلافاصله اعمال خواهند شد.</p>
                            </div>

                        </div>
                    </div>
                </form>
            </div>
        </main>
    </div>
</body>
</html>
