<?php
header('Content-Type: text/html; charset=utf-8');
session_start();
require_once '../../api/db.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: ../../login.php");
    exit();
}

function safe_output($text) {
    return htmlspecialchars($text, ENT_QUOTES, 'UTF-8');
}

$defaults = [
    'whatsapp_number' => '',
    'auto_send_enabled' => '0',
    'sms_provider' => 'melipayamak',
    'sms_username' => '',
    'sms_password' => '',
    'sms_sender' => '',
    'sms_enabled' => '0',
    'msg_pending' => 'سلام {name} عزیز

سفارش شما با کد {code} ثبت شد.

مبلغ: {price} تومان',
    'msg_processing' => 'سلام {name} عزیز

سفارش {code} در حال شستشو است.',
    'msg_ready' => 'سلام {name} عزیز

سفارش {code} آماده تحویل است.

لطفا جهت دریافت تماس بگیرید.',
    'msg_delivered' => 'سلام {name} عزیز

از اعتماد شما سپاسگزاریم.

کد سفارش: {code}'
];

$settings = $defaults;
try {
    $result = $conn->query("SELECT setting_key, setting_value FROM settings");
    while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
        if (!empty($row['setting_value'])) {
            $settings[$row['setting_key']] = $row['setting_value'];
        }
    }
} catch (PDOException $e) {}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $keys = ['whatsapp_number', 'auto_send_enabled', 'sms_provider', 'sms_username', 'sms_password', 'sms_sender', 'sms_enabled', 'msg_pending', 'msg_processing', 'msg_ready', 'msg_delivered'];
    
    try {
        foreach ($keys as $key) {
            $value = $_POST[$key] ?? '';
            $stmt = $conn->prepare("INSERT INTO settings (setting_key, setting_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE setting_value = ?");
            $stmt->execute([$key, $value, $value]);
        }
        $success = true;
        $settings = $defaults;
        $result = $conn->query("SELECT setting_key, setting_value FROM settings");
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            if (!empty($row['setting_value'])) {
                $settings[$row['setting_key']] = $row['setting_value'];
            }
        }
    } catch (PDOException $e) {
        $error = true;
    }
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تنظیمات پیامک و واتساپ | پاکشو</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@100..900&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Vazirmatn', sans-serif; }
        /* Custom Scrollbar for Textareas */
        textarea::-webkit-scrollbar { width: 6px; }
        textarea::-webkit-scrollbar-track { background: #f1f5f9; }
        textarea::-webkit-scrollbar-thumb { background: #cbd5e1; border-radius: 4px; }
        textarea::-webkit-scrollbar-thumb:hover { background: #94a3b8; }
    </style>
</head>
<body class="bg-slate-50 text-gray-800 antialiased">
    <div class="min-h-screen flex flex-col">
        
        <!-- Header -->
        <header class="bg-white/90 backdrop-blur border-b border-gray-200 sticky top-0 z-50 px-6 py-4">
            <div class="max-w-7xl mx-auto flex items-center gap-5">
                <a href="settings.php" class="w-10 h-10 rounded-xl bg-gray-50 border border-gray-200 hover:bg-white hover:border-blue-300 hover:text-blue-600 hover:shadow-md transition-all duration-300 flex items-center justify-center text-gray-500">
                    <i class="fa-solid fa-arrow-right"></i>
                </a>
                <div>
                    <h1 class="text-xl font-bold text-gray-800">تنظیمات پیام‌رسانی</h1>
                    <p class="text-xs text-gray-500 mt-0.5">مدیریت درگاه‌های پیامک و واتساپ</p>
                </div>
            </div>
        </header>

        <main class="flex-1 p-6 md:p-8">
            <div class="max-w-7xl mx-auto">
                
                <!-- Notifications -->
                <?php if (isset($success)): ?>
                <div class="mb-8 p-4 bg-emerald-50 border border-emerald-200 rounded-xl text-emerald-700 flex items-center gap-3 animate-pulse">
                    <i class="fa-solid fa-circle-check text-xl"></i>
                    <span class="font-medium">تنظیمات با موفقیت ذخیره و اعمال شد.</span>
                </div>
                <?php endif; ?>

                <?php if (isset($error)): ?>
                <div class="mb-8 p-4 bg-rose-50 border border-rose-200 rounded-xl text-rose-700 flex items-center gap-3">
                    <i class="fa-solid fa-circle-exclamation text-xl"></i>
                    <span class="font-medium">خطا در برقراری ارتباط با پایگاه داده.</span>
                </div>
                <?php endif; ?>

                <form method="POST" class="space-y-8">
                    
                    <div class="grid grid-cols-1 lg:grid-cols-12 gap-8">
                        
                        <!-- Left Column: Gateways (WhatsApp & SMS) -->
                        <div class="lg:col-span-5 space-y-6">
                            
                            <!-- WhatsApp Card -->
                            <div class="bg-white rounded-3xl border border-gray-200 overflow-hidden shadow-sm hover:shadow-md transition-shadow">
                                <div class="bg-gradient-to-r from-green-50 to-emerald-50 px-6 py-4 border-b border-green-100 flex items-center justify-between">
                                    <div class="flex items-center gap-3">
                                        <div class="w-10 h-10 rounded-full bg-green-500 text-white flex items-center justify-center shadow-lg shadow-green-200">
                                            <i class="fa-brands fa-whatsapp text-xl"></i>
                                        </div>
                                        <h3 class="font-bold text-gray-800">پیکربندی واتساپ</h3>
                                    </div>
                                    <label class="relative inline-flex items-center cursor-pointer">
                                        <input type="checkbox" name="auto_send_enabled" value="1" class="sr-only peer" <?php echo $settings['auto_send_enabled'] == '1' ? 'checked' : ''; ?>>
                                        <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-green-500"></div>
                                    </label>
                                </div>
                                <div class="p-6">
                                    <label class="block text-xs font-bold text-gray-500 uppercase tracking-wide mb-2">شماره متصل به واتساپ</label>
                                    <div class="relative">
                                        <input type="text" name="whatsapp_number" value="<?php echo safe_output($settings['whatsapp_number']); ?>" 
                                            placeholder="989123456789"
                                            class="w-full pl-4 pr-10 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:bg-white focus:border-green-500 focus:ring-4 focus:ring-green-500/10 transition-all text-left dir-ltr font-mono text-sm" dir="ltr">
                                        <span class="absolute right-4 top-3.5 text-gray-400"><i class="fa-solid fa-mobile-screen"></i></span>
                                    </div>
                                    <p class="text-xs text-gray-400 mt-2 text-right">شماره را با کد کشور (مثال: 98) و بدون علامت + وارد کنید.</p>
                                </div>
                            </div>

                            <!-- SMS Card -->
                            <div class="bg-white rounded-3xl border border-gray-200 overflow-hidden shadow-sm hover:shadow-md transition-shadow">
                                <div class="bg-gradient-to-r from-blue-50 to-indigo-50 px-6 py-4 border-b border-blue-100 flex items-center justify-between">
                                    <div class="flex items-center gap-3">
                                        <div class="w-10 h-10 rounded-full bg-blue-600 text-white flex items-center justify-center shadow-lg shadow-blue-200">
                                            <i class="fa-solid fa-comment-sms text-xl"></i>
                                        </div>
                                        <h3 class="font-bold text-gray-800">پیکربندی پیامک</h3>
                                    </div>
                                    <label class="relative inline-flex items-center cursor-pointer">
                                        <input type="checkbox" name="sms_enabled" value="1" class="sr-only peer" <?php echo $settings['sms_enabled'] == '1' ? 'checked' : ''; ?>>
                                        <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600"></div>
                                    </label>
                                </div>
                                <div class="p-6 space-y-5">
                                    <div>
                                        <label class="block text-xs font-bold text-gray-500 uppercase tracking-wide mb-2">پنل پیامکی</label>
                                        <div class="relative">
                                            <select name="sms_provider" class="w-full pl-4 pr-10 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:bg-white focus:border-blue-500 focus:ring-4 focus:ring-blue-500/10 transition-all appearance-none">
                                                <option value="melipayamak" <?php echo $settings['sms_provider'] == 'melipayamak' ? 'selected' : ''; ?>>ملی پیامک (MeliPayamak)</option>
                                                <option value="kavenegar" <?php echo $settings['sms_provider'] == 'kavenegar' ? 'selected' : ''; ?>>کاوه نگار (Kavenegar)</option>
                                            </select>
                                            <span class="absolute left-4 top-3.5 text-gray-500 pointer-events-none"><i class="fa-solid fa-chevron-down text-xs"></i></span>
                                            <span class="absolute right-4 top-3.5 text-gray-400"><i class="fa-solid fa-server"></i></span>
                                        </div>
                                    </div>
                                    
                                    <div class="grid grid-cols-2 gap-4">
                                        <div>
                                            <label class="block text-xs font-bold text-gray-500 mb-2">نام کاربری</label>
                                            <input type="text" name="sms_username" value="<?php echo safe_output($settings['sms_username']); ?>" 
                                                class="w-full px-3 py-2.5 bg-gray-50 border border-gray-200 rounded-lg focus:bg-white focus:border-blue-500 transition-all text-sm">
                                        </div>
                                        <div>
                                            <label class="block text-xs font-bold text-gray-500 mb-2">رمز عبور / API Key</label>
                                            <input type="password" name="sms_password" value="<?php echo safe_output($settings['sms_password']); ?>" 
                                                class="w-full px-3 py-2.5 bg-gray-50 border border-gray-200 rounded-lg focus:bg-white focus:border-blue-500 transition-all text-sm">
                                        </div>
                                    </div>

                                    <div>
                                        <label class="block text-xs font-bold text-gray-500 uppercase tracking-wide mb-2">شماره فرستنده</label>
                                        <div class="relative">
                                            <input type="text" name="sms_sender" value="<?php echo safe_output($settings['sms_sender']); ?>" 
                                                placeholder="مثال: 5000..."
                                                class="w-full pl-4 pr-10 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:bg-white focus:border-blue-500 focus:ring-4 focus:ring-blue-500/10 transition-all text-left dir-ltr font-mono text-sm" dir="ltr">
                                            <span class="absolute right-4 top-3.5 text-gray-400"><i class="fa-solid fa-hashtag"></i></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Save Button (Sticky on Mobile) -->
                            <div class="sticky bottom-6 z-10">
                                <button type="submit" class="w-full py-4 bg-gray-900 hover:bg-black text-white font-bold rounded-2xl shadow-xl shadow-gray-400/20 transition-all transform active:scale-95 flex items-center justify-center gap-2">
                                    <i class="fa-solid fa-floppy-disk"></i>
                                    ذخیره کلیه تنظیمات
                                </button>
                            </div>
                        </div>

                        <!-- Right Column: Message Templates -->
                        <div class="lg:col-span-7 space-y-6">
                            
                            <div class="bg-white rounded-3xl border border-gray-200 p-6 shadow-sm">
                                <div class="flex items-center justify-between mb-6 border-b border-gray-100 pb-4">
                                    <h3 class="font-bold text-gray-800 text-lg">
                                        <i class="fa-solid fa-pen-nib ml-2 text-purple-600"></i>قالب‌های پیام
                                    </h3>
                                    <div class="flex gap-2 text-[10px] bg-gray-100 px-3 py-1.5 rounded-full text-gray-600 font-mono" dir="ltr">
                                        <span>{name}</span>
                                        <span>{code}</span>
                                        <span>{price}</span>
                                        <span>{phone}</span>
                                    </div>
                                </div>

                                <div class="space-y-6">
                                    
                                    <!-- Pending -->
                                    <div class="group relative bg-amber-50/50 hover:bg-amber-50 rounded-2xl p-4 border border-amber-100 transition-colors">
                                        <label class="flex items-center gap-2 text-sm font-bold text-amber-700 mb-3">
                                            <span class="flex h-2.5 w-2.5 rounded-full bg-amber-500"></span>
                                            وضعیت: در انتظار (ثبت سفارش)
                                        </label>
                                        <textarea name="msg_pending" rows="3" class="w-full bg-white border border-amber-200 rounded-xl p-3 text-sm focus:border-amber-400 focus:ring-2 focus:ring-amber-200 outline-none resize-none transition-all"><?php echo safe_output($settings['msg_pending']); ?></textarea>
                                    </div>

                                    <!-- Processing -->
                                    <div class="group relative bg-blue-50/50 hover:bg-blue-50 rounded-2xl p-4 border border-blue-100 transition-colors">
                                        <label class="flex items-center gap-2 text-sm font-bold text-blue-700 mb-3">
                                            <span class="flex h-2.5 w-2.5 rounded-full bg-blue-500 animate-pulse"></span>
                                            وضعیت: در حال شستشو
                                        </label>
                                        <textarea name="msg_processing" rows="3" class="w-full bg-white border border-blue-200 rounded-xl p-3 text-sm focus:border-blue-400 focus:ring-2 focus:ring-blue-200 outline-none resize-none transition-all"><?php echo safe_output($settings['msg_processing']); ?></textarea>
                                    </div>

                                    <!-- Ready -->
                                    <div class="group relative bg-emerald-50/50 hover:bg-emerald-50 rounded-2xl p-4 border border-emerald-100 transition-colors">
                                        <label class="flex items-center gap-2 text-sm font-bold text-emerald-700 mb-3">
                                            <span class="flex h-2.5 w-2.5 rounded-full bg-emerald-500"></span>
                                            وضعیت: آماده تحویل
                                        </label>
                                        <textarea name="msg_ready" rows="3" class="w-full bg-white border border-emerald-200 rounded-xl p-3 text-sm focus:border-emerald-400 focus:ring-2 focus:ring-emerald-200 outline-none resize-none transition-all"><?php echo safe_output($settings['msg_ready']); ?></textarea>
                                    </div>

                                    <!-- Delivered -->
                                    <div class="group relative bg-gray-50/50 hover:bg-gray-100 rounded-2xl p-4 border border-gray-200 transition-colors">
                                        <label class="flex items-center gap-2 text-sm font-bold text-gray-700 mb-3">
                                            <span class="flex h-2.5 w-2.5 rounded-full bg-gray-500"></span>
                                            وضعیت: تحویل داده شد
                                        </label>
                                        <textarea name="msg_delivered" rows="3" class="w-full bg-white border border-gray-300 rounded-xl p-3 text-sm focus:border-gray-400 focus:ring-2 focus:ring-gray-200 outline-none resize-none transition-all"><?php echo safe_output($settings['msg_delivered']); ?></textarea>
                                    </div>

                                </div>
                            </div>
                        </div>

                    </div>
                </form>
            </div>
        </main>
    </div>
</body>
</html>